/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.parquet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.parquet.io.PositionOutputStream;
import org.opensearch.dataprepper.plugins.sink.s3.ownership.BucketOwnerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

public class S3OutputStream
extends PositionOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(S3OutputStream.class);
    static final String ACCESS_DENIED = "Access Denied";
    protected static final int BUFFER_SIZE = 0xA00000;
    private String bucket;
    private final String key;
    private final byte[] buf;
    private final S3AsyncClient s3Client;
    private final BucketOwnerProvider bucketOwnerProvider;
    private final List<String> etags;
    private int position;
    private String uploadId;
    private boolean open;
    private final String defaultBucket;
    private final ExecutorService executorService;

    public S3OutputStream(S3AsyncClient s3Client, Supplier<String> bucketSupplier, Supplier<String> keySupplier, String defaultBucket, BucketOwnerProvider bucketOwnerProvider) {
        this.s3Client = s3Client;
        this.bucket = bucketSupplier.get();
        this.key = keySupplier.get();
        this.buf = new byte[0xA00000];
        this.position = 0;
        this.etags = new ArrayList<String>();
        this.open = true;
        this.defaultBucket = defaultBucket;
        this.executorService = Executors.newSingleThreadExecutor();
        this.bucketOwnerProvider = bucketOwnerProvider;
    }

    public void write(int b) {
        this.assertOpen();
        if (this.position >= this.buf.length) {
            try {
                this.flushBufferAndRewind();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        this.buf[this.position++] = (byte)b;
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(byte[] byteArray, int o, int l) {
        int len;
        int size;
        this.assertOpen();
        int ofs = o;
        for (len = l; len > (size = this.buf.length - this.position); len -= size) {
            System.arraycopy(byteArray, ofs, this.buf, this.position, size);
            this.position += size;
            try {
                this.flushBufferAndRewind();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            ofs += size;
        }
        System.arraycopy(byteArray, ofs, this.buf, this.position, len);
        this.position += len;
    }

    public void flush() {
    }

    public CompletableFuture<?> close(Consumer<Boolean> runOnCompletion, Consumer<Throwable> runOnError) {
        if (this.open) {
            this.open = false;
            try {
                this.possiblyStartMultipartUpload();
                if (this.position > 0) {
                    this.uploadPart();
                }
                CompletedPart[] completedParts = new CompletedPart[this.etags.size()];
                for (int i = 0; i < this.etags.size(); ++i) {
                    completedParts[i] = (CompletedPart)CompletedPart.builder().eTag(this.etags.get(i)).partNumber(Integer.valueOf(i + 1)).build();
                }
                LOG.debug("Completing S3 multipart upload with {} parts.", (Object)completedParts.length);
                CompletedMultipartUpload completedMultipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(completedParts).build();
                CompleteMultipartUploadRequest completeMultipartUploadRequest = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(this.bucket).expectedBucketOwner((String)this.bucketOwnerProvider.getBucketOwner(this.defaultBucket).orElse(null)).key(this.key).uploadId(this.uploadId).multipartUpload(completedMultipartUpload).build();
                CompletableFuture multipartUploadResponseCompletableFuture = this.s3Client.completeMultipartUpload(completeMultipartUploadRequest);
                multipartUploadResponseCompletableFuture.join();
                runOnCompletion.accept(true);
                return multipartUploadResponseCompletableFuture;
            }
            catch (Exception e) {
                runOnError.accept(e);
                runOnCompletion.accept(false);
            }
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    private void assertOpen() {
        if (!this.open) {
            throw new IllegalStateException("Closed");
        }
    }

    private void flushBufferAndRewind() throws ExecutionException, InterruptedException {
        this.possiblyStartMultipartUpload();
        this.uploadPart();
        this.position = 0;
    }

    private void possiblyStartMultipartUpload() {
        if (this.uploadId == null) {
            try {
                this.createMultipartUpload();
            }
            catch (CompletionException e) {
                if (this.defaultBucket != null && e.getCause() != null && (e.getCause() instanceof NoSuchBucketException || e.getCause().getMessage() != null && e.getCause().getMessage().contains(ACCESS_DENIED))) {
                    this.bucket = this.defaultBucket;
                    LOG.warn("Bucket {} could not be accessed to create multi-part upload, attempting to create multi-part upload to default_bucket {}. Error: {}", new Object[]{this.bucket, this.defaultBucket, e.getCause().getMessage()});
                    this.createMultipartUpload();
                }
                throw e;
            }
            LOG.debug("Created multipart upload {} bucket='{}',key='{}'.", new Object[]{this.uploadId, this.bucket, this.key});
        }
    }

    private void uploadPart() {
        int partNumber = this.etags.size() + 1;
        UploadPartRequest uploadRequest = (UploadPartRequest)UploadPartRequest.builder().bucket(this.bucket).expectedBucketOwner((String)this.bucketOwnerProvider.getBucketOwner(this.defaultBucket).orElse(null)).key(this.key).uploadId(this.uploadId).partNumber(Integer.valueOf(partNumber)).contentLength(Long.valueOf(this.position)).build();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.buf, 0, this.position);
        AsyncRequestBody asyncRequestBody = AsyncRequestBody.fromInputStream((InputStream)inputStream, (Long)Long.valueOf(this.position), (ExecutorService)this.executorService);
        LOG.debug("Writing {} bytes to S3 multipart part number {}.", (Object)this.buf.length, (Object)partNumber);
        CompletableFuture uploadPartResponseFuture = this.s3Client.uploadPart(uploadRequest, asyncRequestBody);
        UploadPartResponse uploadPartResponse = (UploadPartResponse)uploadPartResponseFuture.join();
        this.etags.add(uploadPartResponse.eTag());
    }

    public long getPos() throws IOException {
        return (long)this.position + (long)this.etags.size() * 0xA00000L;
    }

    private void createMultipartUpload() {
        CreateMultipartUploadRequest uploadRequest = (CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(this.bucket).key(this.key).expectedBucketOwner((String)this.bucketOwnerProvider.getBucketOwner(this.bucket).orElse(null)).build();
        CompletableFuture multipartUpload = this.s3Client.createMultipartUpload(uploadRequest);
        CreateMultipartUploadResponse response = (CreateMultipartUploadResponse)multipartUpload.join();
        this.uploadId = response.uploadId();
    }
}

