/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.parquet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;
import org.opensearch.dataprepper.avro.AvroAutoSchemaGenerator;
import org.opensearch.dataprepper.avro.AvroEventConverter;
import org.opensearch.dataprepper.avro.EventDefinedAvroEventConverter;
import org.opensearch.dataprepper.avro.SchemaDefinedAvroEventConverter;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.codec.OutputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;
import org.opensearch.dataprepper.plugins.codec.parquet.CompressionConverter;
import org.opensearch.dataprepper.plugins.codec.parquet.ParquetOutputCodecConfig;
import org.opensearch.dataprepper.plugins.codec.parquet.S3OutputFile;
import org.opensearch.dataprepper.plugins.sink.s3.S3OutputCodecContext;
import org.opensearch.dataprepper.plugins.sink.s3.codec.BufferedCodec;

@DataPrepperPlugin(name="parquet", pluginType=OutputCodec.class, pluginConfigurationType=ParquetOutputCodecConfig.class)
public class ParquetOutputCodec
implements OutputCodec,
BufferedCodec {
    private static final String PARQUET = "parquet";
    private final ParquetOutputCodecConfig config;
    private static Schema schema;
    private final AvroEventConverter avroEventConverter;
    private final AvroAutoSchemaGenerator avroAutoSchemaGenerator;
    private ParquetWriter<GenericRecord> writer;
    private OutputCodecContext codecContext;
    private boolean isClosed = false;

    @DataPrepperPluginConstructor
    public ParquetOutputCodec(ParquetOutputCodecConfig config) {
        Objects.requireNonNull(config);
        this.config = config;
        this.avroAutoSchemaGenerator = new AvroAutoSchemaGenerator();
        if (config.getSchema() != null) {
            schema = ParquetOutputCodec.parseSchema(config.getSchema());
            this.avroEventConverter = new SchemaDefinedAvroEventConverter();
        } else {
            this.avroEventConverter = new EventDefinedAvroEventConverter();
        }
    }

    public synchronized void start(OutputStream outputStream, Event event, OutputCodecContext codecContext) throws IOException {
        Objects.requireNonNull(outputStream);
        Objects.requireNonNull(codecContext);
        if (!(outputStream instanceof PositionOutputStream)) {
            throw new RuntimeException("The Parquet output codec only works with the S3OutputStream and thus only with multi-part uploads.");
        }
        if (!(codecContext instanceof S3OutputCodecContext)) {
            throw new RuntimeException("The Parquet output codec only works with S3 presently");
        }
        PositionOutputStream s3OutputStream = (PositionOutputStream)outputStream;
        CompressionCodecName compressionCodecName = CompressionConverter.convertCodec(((S3OutputCodecContext)codecContext).getCompressionOption());
        this.codecContext = codecContext;
        if (schema == null) {
            schema = this.buildInlineSchemaFromEvent(event);
        }
        S3OutputFile s3OutputFile = new S3OutputFile(s3OutputStream);
        this.buildWriter(s3OutputFile, compressionCodecName);
    }

    public boolean isCompressionInternal() {
        return true;
    }

    public Schema buildInlineSchemaFromEvent(Event event) throws IOException {
        Map data = this.codecContext != null && this.codecContext.getTagsTargetKey() != null ? this.addTagsToEvent(event, this.codecContext.getTagsTargetKey()).toMap() : event.toMap();
        return this.avroAutoSchemaGenerator.autoDetermineSchema(data, this.codecContext);
    }

    private void buildWriter(OutputFile outputFile, CompressionCodecName compressionCodecName) throws IOException {
        this.writer = ((AvroParquetWriter.Builder)AvroParquetWriter.builder((OutputFile)outputFile).withSchema(schema).withCompressionCodec(compressionCodecName)).build();
        this.isClosed = false;
    }

    public void writeEvent(Event event, OutputStream outputStream) throws IOException {
        Event modifiedEvent = this.codecContext.getTagsTargetKey() != null ? this.addTagsToEvent(event, this.codecContext.getTagsTargetKey()) : event;
        GenericRecord parquetRecord = this.avroEventConverter.convertEventDataToAvro(schema, modifiedEvent.toMap(), this.codecContext);
        this.writer.write((Object)parquetRecord);
    }

    public synchronized void complete(OutputStream outputStream) throws IOException {
        this.isClosed = true;
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public String getExtension() {
        return PARQUET;
    }

    public void validateAgainstCodecContext(OutputCodecContext outputCodecContext) {
        if (this.config.isAutoSchema()) {
            return;
        }
        if (outputCodecContext.getIncludeKeys() != null && !outputCodecContext.getIncludeKeys().isEmpty() || outputCodecContext.getExcludeKeys() != null && !outputCodecContext.getExcludeKeys().isEmpty()) {
            throw new InvalidPluginConfigurationException("Providing a user-defined schema and using sink include or exclude keys is not an allowed configuration.");
        }
    }

    static Schema parseSchema(String schemaString) {
        return new Schema.Parser().parse(schemaString);
    }

    @Override
    public Optional<Long> getSize() {
        if (this.writer == null) {
            return Optional.of(0L);
        }
        if (this.isClosed) {
            return Optional.empty();
        }
        return Optional.of(this.writer.getDataSize());
    }
}

