/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.plugins.kafka.configuration.AwsCredentialsConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.MskBrokerConnectionType;

public class AwsConfig
implements AwsCredentialsConfig {
    @JsonProperty(value="msk")
    private AwsMskConfig awsMskConfig;
    @Valid
    @Size(min=1, message="Region cannot be empty string")
    @JsonProperty(value="region")
    private @Valid @Size(min=1, message="Region cannot be empty string") String region;
    @Valid
    @Size(min=20, max=2048, message="sts_role_arn length should be between 20 and 2048 characters")
    @JsonProperty(value="sts_role_arn")
    private @Valid @Size(min=20, max=2048, message="sts_role_arn length should be between 20 and 2048 characters") String stsRoleArn;
    @JsonProperty(value="role_session_name")
    private String stsRoleSessionName;

    public AwsMskConfig getAwsMskConfig() {
        return this.awsMskConfig;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getStsRoleArn() {
        return this.stsRoleArn;
    }

    public String getStsRoleSessionName() {
        return this.stsRoleSessionName;
    }

    @Override
    public AwsCredentialsOptions toCredentialsOptions() {
        return AwsCredentialsOptions.builder().withRegion(this.region).withStsRoleArn(this.stsRoleArn).build();
    }

    public static class AwsMskConfig {
        @Valid
        @Size(min=20, max=2048, message="msk_arn length should be between 20 and 2048 characters")
        @JsonProperty(value="arn")
        private @Valid @Size(min=20, max=2048, message="msk_arn length should be between 20 and 2048 characters") String arn;
        @JsonProperty(value="broker_connection_type")
        private MskBrokerConnectionType brokerConnectionType = MskBrokerConnectionType.SINGLE_VPC;

        public String getArn() {
            return this.arn;
        }

        public MskBrokerConnectionType getBrokerConnectionType() {
            return this.brokerConnectionType;
        }
    }
}

