/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.buffer.serialization;

import java.util.Objects;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.opensearch.dataprepper.model.encryption.EncryptionEngine;
import org.opensearch.dataprepper.plugins.encryption.EncryptionSupplier;
import org.opensearch.dataprepper.plugins.kafka.buffer.serialization.BufferMessageDeserializer;
import org.opensearch.dataprepper.plugins.kafka.buffer.serialization.BufferMessageEncryptionDeserializer;
import org.opensearch.dataprepper.plugins.kafka.buffer.serialization.BufferMessageEncryptionSerializer;
import org.opensearch.dataprepper.plugins.kafka.buffer.serialization.BufferMessageSerializer;
import org.opensearch.dataprepper.plugins.kafka.common.KafkaDataConfig;
import org.opensearch.dataprepper.plugins.kafka.common.serialization.SerializationFactory;

public class BufferSerializationFactory
implements SerializationFactory {
    private final SerializationFactory innerSerializationFactory;
    private final EncryptionSupplier encryptionSupplier;

    public BufferSerializationFactory(SerializationFactory innerSerializationFactory, EncryptionSupplier encryptionSupplier) {
        this.innerSerializationFactory = innerSerializationFactory;
        this.encryptionSupplier = encryptionSupplier;
    }

    @Override
    public Deserializer<?> getDeserializer(KafkaDataConfig dataConfig) {
        String encryptionId = dataConfig.getEncryptionId();
        Deserializer<?> dataDeserializer = this.innerSerializationFactory.getDeserializer(dataConfig);
        if (Objects.isNull(encryptionId)) {
            return new BufferMessageDeserializer(dataDeserializer);
        }
        EncryptionEngine encryptionEngine = this.encryptionSupplier.getEncryptionEngine(encryptionId);
        if (encryptionEngine == null) {
            throw new IllegalArgumentException("Encryption engine not found for encryption_id: " + encryptionId);
        }
        return new BufferMessageEncryptionDeserializer(dataDeserializer, encryptionEngine);
    }

    @Override
    public Serializer<?> getSerializer(KafkaDataConfig dataConfig) {
        String encryptionId = dataConfig.getEncryptionId();
        Serializer<?> dataSerializer = this.innerSerializationFactory.getSerializer(dataConfig);
        if (Objects.isNull(encryptionId)) {
            return new BufferMessageSerializer(this.innerSerializationFactory.getSerializer(dataConfig), dataConfig);
        }
        EncryptionEngine encryptionEngine = this.encryptionSupplier.getEncryptionEngine(encryptionId);
        if (encryptionEngine == null) {
            throw new IllegalArgumentException("Encryption engine not found for encryption_id: " + encryptionId);
        }
        return new BufferMessageEncryptionSerializer(dataSerializer, encryptionEngine);
    }
}

