/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.buffer.serialization;

import com.google.protobuf.ByteString;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serializer;
import org.opensearch.dataprepper.model.encryption.EncryptionEngine;
import org.opensearch.dataprepper.model.encryption.EncryptionEnvelope;
import org.opensearch.dataprepper.plugins.kafka.buffer.KafkaBufferMessage;

class BufferMessageEncryptionSerializer<T>
implements Serializer<T> {
    private final Serializer<T> dataSerializer;
    private final EncryptionEngine encryptionEngine;

    public BufferMessageEncryptionSerializer(Serializer<T> dataSerializer, EncryptionEngine encryptionEngine) {
        this.dataSerializer = Objects.requireNonNull(dataSerializer);
        this.encryptionEngine = Objects.requireNonNull(encryptionEngine);
    }

    public byte[] serialize(String topic, T data) {
        if (data == null) {
            return null;
        }
        byte[] serializedData = this.dataSerializer.serialize(topic, data);
        EncryptionEnvelope encryptionEnvelope = this.encryptionEngine.encrypt(serializedData);
        KafkaBufferMessage.BufferData bufferedData = this.buildProtobufMessage(encryptionEnvelope);
        return bufferedData.toByteArray();
    }

    Serializer<T> getDataSerializer() {
        return this.dataSerializer;
    }

    private KafkaBufferMessage.BufferData buildProtobufMessage(EncryptionEnvelope encryptionEnvelope) {
        return KafkaBufferMessage.BufferData.newBuilder().setEncryptedDataKey(ByteString.copyFromUtf8((String)encryptionEnvelope.getEncryptedDataKey())).setData(ByteString.copyFrom((byte[])encryptionEnvelope.getEncryptedData())).setEncrypted(true).setMessageFormat(KafkaBufferMessage.MessageFormat.MESSAGE_FORMAT_BYTES).build();
    }
}

