/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.CustomKeyStoreType;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.services.kms.model.XksProxyAuthenticationCredentialType;
import software.amazon.awssdk.services.kms.model.XksProxyConnectivityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomKeyStoreRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, CreateCustomKeyStoreRequest> {
    private static final SdkField<String> CUSTOM_KEY_STORE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomKeyStoreName").getter(CreateCustomKeyStoreRequest.getter(CreateCustomKeyStoreRequest::customKeyStoreName)).setter(CreateCustomKeyStoreRequest.setter(Builder::customKeyStoreName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKeyStoreName").build()}).build();
    private static final SdkField<String> CLOUD_HSM_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudHsmClusterId").getter(CreateCustomKeyStoreRequest.getter(CreateCustomKeyStoreRequest::cloudHsmClusterId)).setter(CreateCustomKeyStoreRequest.setter(Builder::cloudHsmClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudHsmClusterId").build()}).build();
    private static final SdkField<String> TRUST_ANCHOR_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustAnchorCertificate").getter(CreateCustomKeyStoreRequest.getter(CreateCustomKeyStoreRequest::trustAnchorCertificate)).setter(CreateCustomKeyStoreRequest.setter(Builder::trustAnchorCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustAnchorCertificate").build()}).build();
    private static final SdkField<String> KEY_STORE_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyStorePassword").getter(CreateCustomKeyStoreRequest.getter(CreateCustomKeyStoreRequest::keyStorePassword)).setter(CreateCustomKeyStoreRequest.setter(Builder::keyStorePassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyStorePassword").build()}).build();
    private static final SdkField<String> CUSTOM_KEY_STORE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomKeyStoreType").getter(CreateCustomKeyStoreRequest.getter(CreateCustomKeyStoreRequest::customKeyStoreTypeAsString)).setter(CreateCustomKeyStoreRequest.setter(Builder::customKeyStoreType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKeyStoreType").build()}).build();
    private static final SdkField<String> XKS_PROXY_URI_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XksProxyUriEndpoint").getter(CreateCustomKeyStoreRequest.getter(CreateCustomKeyStoreRequest::xksProxyUriEndpoint)).setter(CreateCustomKeyStoreRequest.setter(Builder::xksProxyUriEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XksProxyUriEndpoint").build()}).build();
    private static final SdkField<String> XKS_PROXY_URI_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XksProxyUriPath").getter(CreateCustomKeyStoreRequest.getter(CreateCustomKeyStoreRequest::xksProxyUriPath)).setter(CreateCustomKeyStoreRequest.setter(Builder::xksProxyUriPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XksProxyUriPath").build()}).build();
    private static final SdkField<String> XKS_PROXY_VPC_ENDPOINT_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XksProxyVpcEndpointServiceName").getter(CreateCustomKeyStoreRequest.getter(CreateCustomKeyStoreRequest::xksProxyVpcEndpointServiceName)).setter(CreateCustomKeyStoreRequest.setter(Builder::xksProxyVpcEndpointServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XksProxyVpcEndpointServiceName").build()}).build();
    private static final SdkField<XksProxyAuthenticationCredentialType> XKS_PROXY_AUTHENTICATION_CREDENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("XksProxyAuthenticationCredential").getter(CreateCustomKeyStoreRequest.getter(CreateCustomKeyStoreRequest::xksProxyAuthenticationCredential)).setter(CreateCustomKeyStoreRequest.setter(Builder::xksProxyAuthenticationCredential)).constructor(XksProxyAuthenticationCredentialType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XksProxyAuthenticationCredential").build()}).build();
    private static final SdkField<String> XKS_PROXY_CONNECTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XksProxyConnectivity").getter(CreateCustomKeyStoreRequest.getter(CreateCustomKeyStoreRequest::xksProxyConnectivityAsString)).setter(CreateCustomKeyStoreRequest.setter(Builder::xksProxyConnectivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XksProxyConnectivity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_KEY_STORE_NAME_FIELD, CLOUD_HSM_CLUSTER_ID_FIELD, TRUST_ANCHOR_CERTIFICATE_FIELD, KEY_STORE_PASSWORD_FIELD, CUSTOM_KEY_STORE_TYPE_FIELD, XKS_PROXY_URI_ENDPOINT_FIELD, XKS_PROXY_URI_PATH_FIELD, XKS_PROXY_VPC_ENDPOINT_SERVICE_NAME_FIELD, XKS_PROXY_AUTHENTICATION_CREDENTIAL_FIELD, XKS_PROXY_CONNECTIVITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCustomKeyStoreRequest.memberNameToFieldInitializer();
    private final String customKeyStoreName;
    private final String cloudHsmClusterId;
    private final String trustAnchorCertificate;
    private final String keyStorePassword;
    private final String customKeyStoreType;
    private final String xksProxyUriEndpoint;
    private final String xksProxyUriPath;
    private final String xksProxyVpcEndpointServiceName;
    private final XksProxyAuthenticationCredentialType xksProxyAuthenticationCredential;
    private final String xksProxyConnectivity;

    private CreateCustomKeyStoreRequest(BuilderImpl builder) {
        super(builder);
        this.customKeyStoreName = builder.customKeyStoreName;
        this.cloudHsmClusterId = builder.cloudHsmClusterId;
        this.trustAnchorCertificate = builder.trustAnchorCertificate;
        this.keyStorePassword = builder.keyStorePassword;
        this.customKeyStoreType = builder.customKeyStoreType;
        this.xksProxyUriEndpoint = builder.xksProxyUriEndpoint;
        this.xksProxyUriPath = builder.xksProxyUriPath;
        this.xksProxyVpcEndpointServiceName = builder.xksProxyVpcEndpointServiceName;
        this.xksProxyAuthenticationCredential = builder.xksProxyAuthenticationCredential;
        this.xksProxyConnectivity = builder.xksProxyConnectivity;
    }

    public final String customKeyStoreName() {
        return this.customKeyStoreName;
    }

    public final String cloudHsmClusterId() {
        return this.cloudHsmClusterId;
    }

    public final String trustAnchorCertificate() {
        return this.trustAnchorCertificate;
    }

    public final String keyStorePassword() {
        return this.keyStorePassword;
    }

    public final CustomKeyStoreType customKeyStoreType() {
        return CustomKeyStoreType.fromValue(this.customKeyStoreType);
    }

    public final String customKeyStoreTypeAsString() {
        return this.customKeyStoreType;
    }

    public final String xksProxyUriEndpoint() {
        return this.xksProxyUriEndpoint;
    }

    public final String xksProxyUriPath() {
        return this.xksProxyUriPath;
    }

    public final String xksProxyVpcEndpointServiceName() {
        return this.xksProxyVpcEndpointServiceName;
    }

    public final XksProxyAuthenticationCredentialType xksProxyAuthenticationCredential() {
        return this.xksProxyAuthenticationCredential;
    }

    public final XksProxyConnectivityType xksProxyConnectivity() {
        return XksProxyConnectivityType.fromValue(this.xksProxyConnectivity);
    }

    public final String xksProxyConnectivityAsString() {
        return this.xksProxyConnectivity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.customKeyStoreName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudHsmClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustAnchorCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyStorePassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.customKeyStoreTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.xksProxyUriEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.xksProxyUriPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.xksProxyVpcEndpointServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.xksProxyAuthenticationCredential());
        hashCode = 31 * hashCode + Objects.hashCode(this.xksProxyConnectivityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomKeyStoreRequest)) {
            return false;
        }
        CreateCustomKeyStoreRequest other = (CreateCustomKeyStoreRequest)((Object)obj);
        return Objects.equals(this.customKeyStoreName(), other.customKeyStoreName()) && Objects.equals(this.cloudHsmClusterId(), other.cloudHsmClusterId()) && Objects.equals(this.trustAnchorCertificate(), other.trustAnchorCertificate()) && Objects.equals(this.keyStorePassword(), other.keyStorePassword()) && Objects.equals(this.customKeyStoreTypeAsString(), other.customKeyStoreTypeAsString()) && Objects.equals(this.xksProxyUriEndpoint(), other.xksProxyUriEndpoint()) && Objects.equals(this.xksProxyUriPath(), other.xksProxyUriPath()) && Objects.equals(this.xksProxyVpcEndpointServiceName(), other.xksProxyVpcEndpointServiceName()) && Objects.equals(this.xksProxyAuthenticationCredential(), other.xksProxyAuthenticationCredential()) && Objects.equals(this.xksProxyConnectivityAsString(), other.xksProxyConnectivityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCustomKeyStoreRequest").add("CustomKeyStoreName", (Object)this.customKeyStoreName()).add("CloudHsmClusterId", (Object)this.cloudHsmClusterId()).add("TrustAnchorCertificate", (Object)this.trustAnchorCertificate()).add("KeyStorePassword", (Object)(this.keyStorePassword() == null ? null : "*** Sensitive Data Redacted ***")).add("CustomKeyStoreType", (Object)this.customKeyStoreTypeAsString()).add("XksProxyUriEndpoint", (Object)this.xksProxyUriEndpoint()).add("XksProxyUriPath", (Object)this.xksProxyUriPath()).add("XksProxyVpcEndpointServiceName", (Object)this.xksProxyVpcEndpointServiceName()).add("XksProxyAuthenticationCredential", (Object)this.xksProxyAuthenticationCredential()).add("XksProxyConnectivity", (Object)this.xksProxyConnectivityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomKeyStoreName": {
                return Optional.ofNullable(clazz.cast(this.customKeyStoreName()));
            }
            case "CloudHsmClusterId": {
                return Optional.ofNullable(clazz.cast(this.cloudHsmClusterId()));
            }
            case "TrustAnchorCertificate": {
                return Optional.ofNullable(clazz.cast(this.trustAnchorCertificate()));
            }
            case "KeyStorePassword": {
                return Optional.ofNullable(clazz.cast(this.keyStorePassword()));
            }
            case "CustomKeyStoreType": {
                return Optional.ofNullable(clazz.cast(this.customKeyStoreTypeAsString()));
            }
            case "XksProxyUriEndpoint": {
                return Optional.ofNullable(clazz.cast(this.xksProxyUriEndpoint()));
            }
            case "XksProxyUriPath": {
                return Optional.ofNullable(clazz.cast(this.xksProxyUriPath()));
            }
            case "XksProxyVpcEndpointServiceName": {
                return Optional.ofNullable(clazz.cast(this.xksProxyVpcEndpointServiceName()));
            }
            case "XksProxyAuthenticationCredential": {
                return Optional.ofNullable(clazz.cast(this.xksProxyAuthenticationCredential()));
            }
            case "XksProxyConnectivity": {
                return Optional.ofNullable(clazz.cast(this.xksProxyConnectivityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CustomKeyStoreName", CUSTOM_KEY_STORE_NAME_FIELD);
        map.put("CloudHsmClusterId", CLOUD_HSM_CLUSTER_ID_FIELD);
        map.put("TrustAnchorCertificate", TRUST_ANCHOR_CERTIFICATE_FIELD);
        map.put("KeyStorePassword", KEY_STORE_PASSWORD_FIELD);
        map.put("CustomKeyStoreType", CUSTOM_KEY_STORE_TYPE_FIELD);
        map.put("XksProxyUriEndpoint", XKS_PROXY_URI_ENDPOINT_FIELD);
        map.put("XksProxyUriPath", XKS_PROXY_URI_PATH_FIELD);
        map.put("XksProxyVpcEndpointServiceName", XKS_PROXY_VPC_ENDPOINT_SERVICE_NAME_FIELD);
        map.put("XksProxyAuthenticationCredential", XKS_PROXY_AUTHENTICATION_CREDENTIAL_FIELD);
        map.put("XksProxyConnectivity", XKS_PROXY_CONNECTIVITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomKeyStoreRequest, T> g) {
        return obj -> g.apply((CreateCustomKeyStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String customKeyStoreName;
        private String cloudHsmClusterId;
        private String trustAnchorCertificate;
        private String keyStorePassword;
        private String customKeyStoreType;
        private String xksProxyUriEndpoint;
        private String xksProxyUriPath;
        private String xksProxyVpcEndpointServiceName;
        private XksProxyAuthenticationCredentialType xksProxyAuthenticationCredential;
        private String xksProxyConnectivity;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomKeyStoreRequest model) {
            super(model);
            this.customKeyStoreName(model.customKeyStoreName);
            this.cloudHsmClusterId(model.cloudHsmClusterId);
            this.trustAnchorCertificate(model.trustAnchorCertificate);
            this.keyStorePassword(model.keyStorePassword);
            this.customKeyStoreType(model.customKeyStoreType);
            this.xksProxyUriEndpoint(model.xksProxyUriEndpoint);
            this.xksProxyUriPath(model.xksProxyUriPath);
            this.xksProxyVpcEndpointServiceName(model.xksProxyVpcEndpointServiceName);
            this.xksProxyAuthenticationCredential(model.xksProxyAuthenticationCredential);
            this.xksProxyConnectivity(model.xksProxyConnectivity);
        }

        public final String getCustomKeyStoreName() {
            return this.customKeyStoreName;
        }

        public final void setCustomKeyStoreName(String customKeyStoreName) {
            this.customKeyStoreName = customKeyStoreName;
        }

        @Override
        public final Builder customKeyStoreName(String customKeyStoreName) {
            this.customKeyStoreName = customKeyStoreName;
            return this;
        }

        public final String getCloudHsmClusterId() {
            return this.cloudHsmClusterId;
        }

        public final void setCloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
        }

        @Override
        public final Builder cloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
            return this;
        }

        public final String getTrustAnchorCertificate() {
            return this.trustAnchorCertificate;
        }

        public final void setTrustAnchorCertificate(String trustAnchorCertificate) {
            this.trustAnchorCertificate = trustAnchorCertificate;
        }

        @Override
        public final Builder trustAnchorCertificate(String trustAnchorCertificate) {
            this.trustAnchorCertificate = trustAnchorCertificate;
            return this;
        }

        public final String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public final void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        @Override
        public final Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public final String getCustomKeyStoreType() {
            return this.customKeyStoreType;
        }

        public final void setCustomKeyStoreType(String customKeyStoreType) {
            this.customKeyStoreType = customKeyStoreType;
        }

        @Override
        public final Builder customKeyStoreType(String customKeyStoreType) {
            this.customKeyStoreType = customKeyStoreType;
            return this;
        }

        @Override
        public final Builder customKeyStoreType(CustomKeyStoreType customKeyStoreType) {
            this.customKeyStoreType(customKeyStoreType == null ? null : customKeyStoreType.toString());
            return this;
        }

        public final String getXksProxyUriEndpoint() {
            return this.xksProxyUriEndpoint;
        }

        public final void setXksProxyUriEndpoint(String xksProxyUriEndpoint) {
            this.xksProxyUriEndpoint = xksProxyUriEndpoint;
        }

        @Override
        public final Builder xksProxyUriEndpoint(String xksProxyUriEndpoint) {
            this.xksProxyUriEndpoint = xksProxyUriEndpoint;
            return this;
        }

        public final String getXksProxyUriPath() {
            return this.xksProxyUriPath;
        }

        public final void setXksProxyUriPath(String xksProxyUriPath) {
            this.xksProxyUriPath = xksProxyUriPath;
        }

        @Override
        public final Builder xksProxyUriPath(String xksProxyUriPath) {
            this.xksProxyUriPath = xksProxyUriPath;
            return this;
        }

        public final String getXksProxyVpcEndpointServiceName() {
            return this.xksProxyVpcEndpointServiceName;
        }

        public final void setXksProxyVpcEndpointServiceName(String xksProxyVpcEndpointServiceName) {
            this.xksProxyVpcEndpointServiceName = xksProxyVpcEndpointServiceName;
        }

        @Override
        public final Builder xksProxyVpcEndpointServiceName(String xksProxyVpcEndpointServiceName) {
            this.xksProxyVpcEndpointServiceName = xksProxyVpcEndpointServiceName;
            return this;
        }

        public final XksProxyAuthenticationCredentialType.Builder getXksProxyAuthenticationCredential() {
            return this.xksProxyAuthenticationCredential != null ? this.xksProxyAuthenticationCredential.toBuilder() : null;
        }

        public final void setXksProxyAuthenticationCredential(XksProxyAuthenticationCredentialType.BuilderImpl xksProxyAuthenticationCredential) {
            this.xksProxyAuthenticationCredential = xksProxyAuthenticationCredential != null ? xksProxyAuthenticationCredential.build() : null;
        }

        @Override
        public final Builder xksProxyAuthenticationCredential(XksProxyAuthenticationCredentialType xksProxyAuthenticationCredential) {
            this.xksProxyAuthenticationCredential = xksProxyAuthenticationCredential;
            return this;
        }

        public final String getXksProxyConnectivity() {
            return this.xksProxyConnectivity;
        }

        public final void setXksProxyConnectivity(String xksProxyConnectivity) {
            this.xksProxyConnectivity = xksProxyConnectivity;
        }

        @Override
        public final Builder xksProxyConnectivity(String xksProxyConnectivity) {
            this.xksProxyConnectivity = xksProxyConnectivity;
            return this;
        }

        @Override
        public final Builder xksProxyConnectivity(XksProxyConnectivityType xksProxyConnectivity) {
            this.xksProxyConnectivity(xksProxyConnectivity == null ? null : xksProxyConnectivity.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomKeyStoreRequest build() {
            return new CreateCustomKeyStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCustomKeyStoreRequest> {
        public Builder customKeyStoreName(String var1);

        public Builder cloudHsmClusterId(String var1);

        public Builder trustAnchorCertificate(String var1);

        public Builder keyStorePassword(String var1);

        public Builder customKeyStoreType(String var1);

        public Builder customKeyStoreType(CustomKeyStoreType var1);

        public Builder xksProxyUriEndpoint(String var1);

        public Builder xksProxyUriPath(String var1);

        public Builder xksProxyVpcEndpointServiceName(String var1);

        public Builder xksProxyAuthenticationCredential(XksProxyAuthenticationCredentialType var1);

        default public Builder xksProxyAuthenticationCredential(Consumer<XksProxyAuthenticationCredentialType.Builder> xksProxyAuthenticationCredential) {
            return this.xksProxyAuthenticationCredential((XksProxyAuthenticationCredentialType)((XksProxyAuthenticationCredentialType.Builder)XksProxyAuthenticationCredentialType.builder().applyMutation(xksProxyAuthenticationCredential)).build());
        }

        public Builder xksProxyConnectivity(String var1);

        public Builder xksProxyConnectivity(XksProxyConnectivityType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

