/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model;

import java.util.List;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.SortingOptions;

public class SearchPointInTimeRequest {
    private final String pitId;
    private final String keepAlive;
    private final String index;
    private final List<String> searchAfter;
    private final Integer paginationSize;
    private final String query;
    private final List<SortingOptions> sortingOptions;

    public String getIndex() {
        return this.index;
    }

    public List<SortingOptions> getSortOptions() {
        return this.sortingOptions;
    }

    public String getQuery() {
        return this.query;
    }

    public Integer getPaginationSize() {
        return this.paginationSize;
    }

    public List<String> getSearchAfter() {
        return this.searchAfter;
    }

    public String getPitId() {
        return this.pitId;
    }

    public String getKeepAlive() {
        return this.keepAlive;
    }

    private SearchPointInTimeRequest(Builder builder) {
        this.pitId = builder.pitId;
        this.keepAlive = builder.keepAlive;
        this.index = builder.index;
        this.searchAfter = builder.searchAfter;
        this.paginationSize = builder.paginationSize;
        this.query = builder.query;
        this.sortingOptions = builder.sortingOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String pitId;
        private String keepAlive;
        private String index;
        private List<String> searchAfter;
        private Integer paginationSize;
        private String query;
        private List<SortingOptions> sortingOptions;

        public Builder withQuery(String query) {
            this.query = query;
            return this;
        }

        public Builder withSortOptions(List<SortingOptions> sortingOptions) {
            this.sortingOptions = sortingOptions;
            return this;
        }

        public Builder withPitId(String pitId) {
            this.pitId = pitId;
            return this;
        }

        public Builder withPaginationSize(Integer paginationSize) {
            this.paginationSize = paginationSize;
            return this;
        }

        public Builder withSearchAfter(List<String> searchAfter) {
            this.searchAfter = searchAfter;
            return this;
        }

        public Builder withKeepAlive(String keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder withIndex(String index) {
            this.index = index;
            return this;
        }

        public SearchPointInTimeRequest build() {
            return new SearchPointInTimeRequest(this);
        }
    }
}

