/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Min;
import java.time.Duration;
import java.time.Instant;

public class SchedulingParameterConfiguration {
    @JsonProperty(value="interval")
    private Duration interval = Duration.ofHours(8L);
    @Min(value=1L)
    @JsonProperty(value="index_read_count")
    private @Min(value=1L) int indexReadCount = 1;
    @JsonProperty(value="start_time")
    private String startTime = Instant.now().toString();
    @JsonIgnore
    private Instant startTimeInstant;

    public Duration getInterval() {
        return this.interval;
    }

    public int getIndexReadCount() {
        return this.indexReadCount;
    }

    public Instant getStartTime() {
        return this.startTimeInstant;
    }

    @AssertTrue(message="start_time must be a valid Java Instant format such as \"2007-12-03T10:15:30.00Z\"")
    @AssertTrue(message="start_time must be a valid Java Instant format such as \"2007-12-03T10:15:30.00Z\"") boolean isStartTimeValid() {
        try {
            this.startTimeInstant = Instant.parse(this.startTime);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

