/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.plugins.source.opensearch.AuthConfig;
import org.opensearch.dataprepper.plugins.source.opensearch.configuration.AwsAuthenticationConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.configuration.ConnectionConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.configuration.IndexParametersConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.configuration.SchedulingParameterConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.configuration.SearchConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.DistributionVersion;

public class OpenSearchSourceConfiguration {
    @NotNull
    @JsonProperty(value="hosts")
    private List<String> hosts;
    @Deprecated
    @JsonProperty(value="username")
    private String username;
    @Deprecated
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="authentication")
    private AuthConfig authConfig;
    @JsonProperty(value="disable_authentication")
    private Boolean disableAuthentication = false;
    @JsonProperty(value="acknowledgments")
    private Boolean acknowledgments = false;
    @JsonProperty(value="connection")
    @Valid
    private ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration();
    @JsonProperty(value="indices")
    @Valid
    private IndexParametersConfiguration indexParametersConfiguration;
    @JsonProperty(value="aws")
    @Valid
    private AwsAuthenticationConfiguration awsAuthenticationOptions;
    @JsonProperty(value="scheduling")
    @Valid
    private SchedulingParameterConfiguration schedulingParameterConfiguration = new SchedulingParameterConfiguration();
    @JsonProperty(value="search_options")
    @Valid
    private SearchConfiguration searchConfiguration = new SearchConfiguration();
    @JsonProperty(value="distribution_version")
    private String distributionVersion;
    @JsonIgnore
    private DistributionVersion distributionVersionValue;

    public List<String> getHosts() {
        return this.hosts;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean isAuthenticationDisabled() {
        return this.disableAuthentication;
    }

    public Boolean isAcknowledgmentsEnabled() {
        return this.acknowledgments;
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public IndexParametersConfiguration getIndexParametersConfiguration() {
        return this.indexParametersConfiguration;
    }

    public AwsAuthenticationConfiguration getAwsAuthenticationOptions() {
        return this.awsAuthenticationOptions;
    }

    public SchedulingParameterConfiguration getSchedulingParameterConfiguration() {
        return this.schedulingParameterConfiguration;
    }

    public SearchConfiguration getSearchConfiguration() {
        return this.searchConfiguration;
    }

    public DistributionVersion getDistributionVersion() {
        return this.distributionVersionValue;
    }

    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    void validateAuthConfigConflictWithDeprecatedUsernameAndPassword() {
        if (Objects.nonNull(this.authConfig) && (Objects.nonNull(this.username) || Objects.nonNull(this.password))) {
            throw new InvalidPluginConfigurationException("Deprecated username and password cannot be set when authentication is configured.");
        }
    }

    void validateAwsConfigWithUsernameAndPassword() {
        String password;
        String username;
        if (Objects.nonNull(this.authConfig)) {
            username = this.authConfig.getUsername();
            password = this.authConfig.getPassword();
        } else {
            username = this.username;
            password = this.password;
        }
        if (Objects.nonNull(this.awsAuthenticationOptions) && (Objects.nonNull(username) || Objects.nonNull(password) || this.disableAuthentication.booleanValue()) || (Objects.nonNull(username) || Objects.nonNull(password)) && this.disableAuthentication.booleanValue() || Objects.isNull(this.awsAuthenticationOptions) && (Objects.isNull(username) || Objects.isNull(password)) && !this.disableAuthentication.booleanValue()) {
            throw new InvalidPluginConfigurationException("Either username and password, or aws options must be specified. Both cannot be set at once. Authentication can be disabled by setting the disable_authentication flag to true.");
        }
    }

    @AssertTrue(message="distribution_version must be one of [ 'es7', 'opensearch' ]")
    @AssertTrue(message="distribution_version must be one of [ 'es7', 'opensearch' ]") boolean isDistributionVersionValid() {
        try {
            if (this.distributionVersion != null) {
                this.distributionVersionValue = DistributionVersion.valueOf(this.distributionVersion.toUpperCase());
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

