/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.opensearch.indices.GetTemplateResponse;
import org.opensearch.client.opensearch.indices.TemplateMapping;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplate;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplateAPIWrapper;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.LegacyIndexTemplate;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.TemplateStrategy;

class V1TemplateStrategy
implements TemplateStrategy {
    private final IndexTemplateAPIWrapper<GetTemplateResponse> indexTemplateAPIWrapper;

    public V1TemplateStrategy(IndexTemplateAPIWrapper<GetTemplateResponse> indexTemplateAPIWrapper) {
        this.indexTemplateAPIWrapper = indexTemplateAPIWrapper;
    }

    @Override
    public Optional<Long> getExistingTemplateVersion(String templateName) throws IOException {
        return this.indexTemplateAPIWrapper.getTemplate(templateName).map(response -> {
            if (response.result().size() == 1) {
                return ((TemplateMapping)response.result().values().stream().findFirst().get()).version();
            }
            throw new RuntimeException(String.format("Found zero or multiple index templates result when querying for %s", templateName));
        });
    }

    @Override
    public IndexTemplate createIndexTemplate(Map<String, Object> templateMap) {
        return new LegacyIndexTemplate(templateMap);
    }

    @Override
    public void createTemplate(IndexTemplate indexTemplate) throws IOException {
        this.indexTemplateAPIWrapper.putTemplate(indexTemplate);
    }
}

