/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.dataprepper.plugins.sink.opensearch.OpenSearchSinkConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.AbstractIndexManager;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.ClusterSettingsParser;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexManager;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexManagerFactory;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexType;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.TemplateStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicIndexManager
extends AbstractIndexManager {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicIndexManager.class);
    private static final int INDEX_SETUP_RETRY_WAIT_TIME_MS = 1000;
    private Cache<String, IndexManager> indexManagerCache;
    final int CACHE_EXPIRE_AFTER_ACCESS_TIME_MINUTES = 30;
    final int APPROXIMATE_INDEX_MANAGER_SIZE = 32;
    private static final String INVALID_INDEX_CHARACTERS = "[:\\\"*+/\\\\|?#><]";
    private static final Pattern INVALID_REGEX_CHARACTERS_PATTERN = Pattern.compile("[:\\\"*+/\\\\|?#><]");
    private final long cacheSizeInKB = 1024L;
    protected RestHighLevelClient restHighLevelClient;
    protected OpenSearchClient openSearchClient;
    protected OpenSearchSinkConfiguration openSearchSinkConfiguration;
    protected ClusterSettingsParser clusterSettingsParser;
    final IndexType indexType;
    private final IndexManagerFactory indexManagerFactory;
    private final TemplateStrategy templateStrategy;

    public DynamicIndexManager(IndexType indexType, OpenSearchClient openSearchClient, RestHighLevelClient restHighLevelClient, OpenSearchSinkConfiguration openSearchSinkConfiguration, ClusterSettingsParser clusterSettingsParser, TemplateStrategy templateStrategy, IndexManagerFactory indexManagerFactory) {
        super(restHighLevelClient, openSearchClient, openSearchSinkConfiguration, clusterSettingsParser, templateStrategy, "");
        this.templateStrategy = templateStrategy;
        Preconditions.checkNotNull((Object)restHighLevelClient);
        Preconditions.checkNotNull((Object)openSearchSinkConfiguration);
        Preconditions.checkNotNull((Object)clusterSettingsParser);
        this.indexType = indexType;
        this.indexManagerFactory = indexManagerFactory;
        this.openSearchClient = openSearchClient;
        this.restHighLevelClient = restHighLevelClient;
        this.openSearchSinkConfiguration = openSearchSinkConfiguration;
        this.clusterSettingsParser = clusterSettingsParser;
        Caffeine cacheBuilder = Caffeine.newBuilder().recordStats().maximumWeight(1024L).expireAfterAccess(30L, TimeUnit.MINUTES).weigher((k, v) -> 32);
        this.indexManagerCache = cacheBuilder.build();
        Preconditions.checkNotNull(this.indexManagerCache);
    }

    @Override
    public void setupIndex() throws IOException {
    }

    @Override
    public String getIndexName(String dynamicIndexAlias) throws IOException {
        IndexManager indexManager;
        if (dynamicIndexAlias == null) {
            throw new IOException("index alias is null");
        }
        String fullIndexAlias = AbstractIndexManager.getIndexAliasWithDate(dynamicIndexAlias);
        if (this.openSearchSinkConfiguration.getIndexConfiguration().isNormalizeIndex()) {
            fullIndexAlias = this.normalizeIndex(fullIndexAlias);
        }
        if ((indexManager = (IndexManager)this.indexManagerCache.getIfPresent((Object)fullIndexAlias)) == null) {
            indexManager = this.indexManagerFactory.getIndexManager(this.indexType, this.openSearchClient, this.restHighLevelClient, this.openSearchSinkConfiguration, this.templateStrategy, fullIndexAlias);
            this.indexManagerCache.put((Object)fullIndexAlias, (Object)indexManager);
            this.setupIndexWithRetries(indexManager);
        }
        return indexManager.getIndexName(fullIndexAlias);
    }

    private void setupIndexWithRetries(IndexManager indexManager) throws IOException {
        boolean isIndexSetup = false;
        while (!isIndexSetup) {
            try {
                indexManager.setupIndex();
                isIndexSetup = true;
            }
            catch (OpenSearchException e) {
                LOG.warn("Failed to setup dynamic index with an exception. ", (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    LOG.warn("Interrupted while sleeping between index setup retries");
                }
            }
        }
    }

    private String normalizeIndex(String indexName) {
        String normalizedIndexName = indexName.toLowerCase(Locale.ROOT);
        normalizedIndexName = INVALID_REGEX_CHARACTERS_PATTERN.matcher(normalizedIndexName).replaceAll("");
        while (normalizedIndexName.startsWith("_") || normalizedIndexName.startsWith("-")) {
            if (normalizedIndexName.length() == 1) {
                throw new RuntimeException(String.format("Unable to normalize index '%s'. This index name is invalid.", indexName));
            }
            normalizedIndexName = normalizedIndexName.substring(1);
        }
        if (normalizedIndexName.isBlank()) {
            throw new RuntimeException(String.format("Unable to normalize index '%s'. The result after normalization was an empty String.", indexName));
        }
        return normalizedIndexName;
    }
}

