/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.opensearch.OpenSearchBulkActions;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.DataStreamDetector;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStreamIndex {
    private static final Logger LOG = LoggerFactory.getLogger(DataStreamIndex.class);
    private static final String TIMESTAMP_FIELD = "@timestamp";
    private final DataStreamDetector dataStreamDetector;
    private final IndexConfiguration indexConfiguration;

    public DataStreamIndex(DataStreamDetector dataStreamDetector, IndexConfiguration indexConfiguration) {
        this.dataStreamDetector = dataStreamDetector;
        this.indexConfiguration = indexConfiguration;
    }

    public String determineAction(String configuredAction, String indexName) {
        if (this.dataStreamDetector.isDataStream(indexName)) {
            this.validateConfigurationForDataStream(indexName);
            if (configuredAction != null && !configuredAction.equals(OpenSearchBulkActions.CREATE.toString()) && !configuredAction.equals(OpenSearchBulkActions.INDEX.toString())) {
                LOG.warn("Data Stream '{}' requires 'create' action, but '{}' was configured. Using 'create' action.", (Object)indexName, (Object)configuredAction);
            }
            return OpenSearchBulkActions.CREATE.toString();
        }
        return configuredAction != null ? configuredAction : OpenSearchBulkActions.INDEX.toString();
    }

    public void ensureTimestamp(Event event, String indexName) {
        if (this.dataStreamDetector.isDataStream(indexName) && !event.containsKey(TIMESTAMP_FIELD)) {
            event.put(TIMESTAMP_FIELD, (Object)event.getEventHandle().getInternalOriginationTime().toEpochMilli());
        }
    }

    private void validateConfigurationForDataStream(String indexName) {
        if (this.indexConfiguration.getDocumentIdField() != null || this.indexConfiguration.getDocumentId() != null) {
            LOG.warn("Data Stream '{}' with document ID configuration uses first-write-wins behavior. Subsequent writes to the same ID will be ignored.", (Object)indexName);
        }
        if (this.indexConfiguration.getRoutingField() != null || this.indexConfiguration.getRouting() != null) {
            LOG.warn("Data Stream '{}' does not support routing. Routing configuration will be ignored.", (Object)indexName);
        }
    }
}

