/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplate;

class ComposableIndexTemplate
implements IndexTemplate {
    static final String TEMPLATE_KEY = "template";
    static final String INDEX_SETTINGS_KEY = "settings";
    private final Map<String, Object> indexTemplateMap;
    private String name;

    public ComposableIndexTemplate(Map<String, Object> indexTemplateMap) {
        this.indexTemplateMap = new HashMap<String, Object>(indexTemplateMap);
    }

    @Override
    public void setTemplateName(String name) {
        this.name = name;
    }

    @Override
    public void setIndexPatterns(List<String> indexPatterns) {
        this.indexTemplateMap.put("index_patterns", indexPatterns);
    }

    @Override
    public void putCustomSetting(String name, Object value) {
        Map template = (Map)this.indexTemplateMap.computeIfAbsent(TEMPLATE_KEY, key -> new HashMap());
        Map settings = (Map)template.computeIfAbsent(INDEX_SETTINGS_KEY, key -> new HashMap());
        settings.put(name, value);
    }

    @Override
    public Optional<Long> getVersion() {
        if (!this.indexTemplateMap.containsKey("version")) {
            return Optional.empty();
        }
        Number version = (Number)this.indexTemplateMap.get("version");
        return Optional.of(version.longValue());
    }

    public Map<String, Object> getIndexTemplateMap() {
        return Collections.unmodifiableMap(this.indexTemplateMap);
    }

    public String getName() {
        return this.name;
    }
}

