/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.dlq;

import java.util.Objects;
import org.opensearch.client.opensearch.core.bulk.BulkResponseItem;
import org.opensearch.dataprepper.plugins.sink.opensearch.BulkOperationWrapper;

public class FailedBulkOperation {
    private final BulkOperationWrapper bulkOperation;
    private final BulkResponseItem bulkResponseItem;
    private final Throwable failure;

    private FailedBulkOperation(BulkOperationWrapper bulkOperation, BulkResponseItem bulkResponseItem, Throwable failure) {
        Objects.requireNonNull(bulkOperation);
        this.bulkOperation = bulkOperation;
        if (bulkResponseItem == null && failure == null) {
            throw new IllegalArgumentException("bulkResponseItem and failure cannot both be null. One must be provided.");
        }
        this.bulkResponseItem = bulkResponseItem;
        this.failure = failure;
    }

    public BulkOperationWrapper getBulkOperation() {
        return this.bulkOperation;
    }

    public BulkResponseItem getBulkResponseItem() {
        return this.bulkResponseItem;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailedBulkOperation that = (FailedBulkOperation)o;
        return Objects.equals(this.bulkOperation, that.bulkOperation) && Objects.equals(this.bulkResponseItem, that.bulkResponseItem) && Objects.equals(this.failure, that.failure);
    }

    public int hashCode() {
        return Objects.hash(this.bulkOperation, this.bulkResponseItem, this.failure);
    }

    public String toString() {
        return "FailedBulkOperation{bulkOperation='" + String.valueOf(this.bulkOperation) + "', bulkResponseItem='" + String.valueOf(this.bulkResponseItem) + "', failure=" + String.valueOf(this.failure) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BulkOperationWrapper bulkOperation;
        private BulkResponseItem bulkResponseItem;
        private Throwable failure;

        public Builder withBulkOperation(BulkOperationWrapper bulkOperation) {
            this.bulkOperation = bulkOperation;
            return this;
        }

        public Builder withBulkResponseItem(BulkResponseItem bulkResponseItem) {
            this.bulkResponseItem = bulkResponseItem;
            return this;
        }

        public Builder withFailure(Throwable failure) {
            this.failure = failure;
            return this;
        }

        public FailedBulkOperation build() {
            return new FailedBulkOperation(this.bulkOperation, this.bulkResponseItem, this.failure);
        }
    }
}

