/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.bulk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.dataprepper.plugins.sink.opensearch.BulkOperationWrapper;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.AccumulatingBulkRequest;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.SizedDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaClientAccumulatingUncompressedBulkRequest
implements AccumulatingBulkRequest<BulkOperationWrapper, BulkRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(JavaClientAccumulatingUncompressedBulkRequest.class);
    static final int OPERATION_OVERHEAD = 50;
    private final List<BulkOperationWrapper> bulkOperations;
    private BulkRequest.Builder bulkRequestBuilder;
    private long currentBulkSize = 0L;
    private int operationCount = 0;
    private BulkRequest builtRequest;

    public JavaClientAccumulatingUncompressedBulkRequest(BulkRequest.Builder bulkRequestBuilder) {
        this.bulkRequestBuilder = bulkRequestBuilder;
        this.bulkOperations = new ArrayList<BulkOperationWrapper>();
    }

    @Override
    public long estimateSizeInBytesWithDocument(BulkOperationWrapper documentOrOperation) {
        return this.currentBulkSize + this.estimateBulkOperationSize(documentOrOperation);
    }

    @Override
    public void addOperation(BulkOperationWrapper bulkOperation) {
        Long documentLength = this.estimateBulkOperationSize(bulkOperation);
        this.currentBulkSize += documentLength.longValue();
        this.bulkRequestBuilder = this.bulkRequestBuilder.operations(bulkOperation.getBulkOperation(), new BulkOperation[0]);
        ++this.operationCount;
        this.bulkOperations.add(bulkOperation);
    }

    @Override
    public BulkOperationWrapper getOperationAt(int index) {
        return this.bulkOperations.get(index);
    }

    @Override
    public long getEstimatedSizeInBytes() {
        return this.currentBulkSize;
    }

    @Override
    public int getOperationsCount() {
        return this.operationCount;
    }

    @Override
    public List<BulkOperationWrapper> getOperations() {
        return Collections.unmodifiableList(this.bulkOperations);
    }

    @Override
    public BulkRequest getRequest() {
        if (this.builtRequest == null) {
            this.builtRequest = this.bulkRequestBuilder.build();
        }
        return this.builtRequest;
    }

    private long estimateBulkOperationSize(BulkOperationWrapper bulkOperation) {
        Object anyDocument = bulkOperation.getDocument();
        if (anyDocument == null) {
            return 50L;
        }
        if (!(anyDocument instanceof SizedDocument)) {
            throw new IllegalArgumentException("Only SizedDocument is permitted for accumulating bulk requests. " + String.valueOf(bulkOperation));
        }
        SizedDocument sizedDocument = (SizedDocument)anyDocument;
        long documentLength = sizedDocument.getDocumentSize();
        return documentLength + 50L;
    }
}

