/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.bulk;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.transport.JsonEndpoint;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.BulkApiWrapper;

public class Es6BulkApiWrapper
implements BulkApiWrapper {
    private final Supplier<OpenSearchClient> openSearchClientSupplier;

    public Es6BulkApiWrapper(Supplier<OpenSearchClient> openSearchClientSupplier) {
        this.openSearchClientSupplier = openSearchClientSupplier;
    }

    @Override
    public BulkResponse bulk(BulkRequest request) throws IOException, OpenSearchException {
        JsonEndpoint<BulkRequest, BulkResponse, ErrorResponse> endpoint = this.es6BulkEndpoint(request);
        OpenSearchClient openSearchClient = this.openSearchClientSupplier.get();
        return (BulkResponse)((OpenSearchTransport)openSearchClient._transport()).performRequest((Object)request, endpoint, openSearchClient._transportOptions());
    }

    private JsonEndpoint<BulkRequest, BulkResponse, ErrorResponse> es6BulkEndpoint(BulkRequest bulkRequest) {
        return new SimpleEndpoint(request -> "POST", request -> {
            String index = request.index() == null ? this.getFirstOperationIndex((BulkRequest)request) : request.index();
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode((String)index, (StringBuilder)buf);
            buf.append("/_doc");
            buf.append("/_bulk");
            return buf.toString();
        }, request -> {
            HashMap<String, String> params = new HashMap<String, String>();
            if (request.pipeline() != null) {
                params.put("pipeline", request.pipeline());
            }
            if (request.routing() != null) {
                params.put("routing", request.routing());
            }
            if (request.requireAlias() != null) {
                params.put("require_alias", String.valueOf(request.requireAlias()));
            }
            if (request.refresh() != null) {
                params.put("refresh", request.refresh().jsonValue());
            }
            if (request.waitForActiveShards() != null) {
                params.put("wait_for_active_shards", request.waitForActiveShards()._toJsonString());
            }
            if (request.source() != null) {
                params.put("_source", request.source()._toJsonString());
            }
            if (ApiTypeHelper.isDefined((List)request.sourceExcludes())) {
                params.put("_source_excludes", request.sourceExcludes().stream().map(v -> v).collect(Collectors.joining(",")));
            }
            if (ApiTypeHelper.isDefined((List)request.sourceIncludes())) {
                params.put("_source_includes", request.sourceIncludes().stream().map(v -> v).collect(Collectors.joining(",")));
            }
            if (request.timeout() != null) {
                params.put("timeout", request.timeout()._toJsonString());
            }
            return params;
        }, SimpleEndpoint.emptyMap(), true, BulkResponse._DESERIALIZER);
    }

    private String getFirstOperationIndex(BulkRequest bulkRequest) {
        BulkOperation firstBulkOperation = (BulkOperation)bulkRequest.operations().get(0);
        if (firstBulkOperation.isIndex()) {
            return firstBulkOperation.index().index();
        }
        if (firstBulkOperation.isCreate()) {
            return firstBulkOperation.create().index();
        }
        if (firstBulkOperation.isUpdate()) {
            return firstBulkOperation.update().index();
        }
        if (firstBulkOperation.isDelete()) {
            return firstBulkOperation.delete().index();
        }
        throw new IllegalArgumentException(String.format("Unsupported bulk operation kind: %s", firstBulkOperation._kind()));
    }
}

