/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.DlqConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.OpenSearchSinkConfig;

public class RetryConfiguration {
    public static final String DLQ_FILE = "dlq_file";
    public static final String MAX_RETRIES = "max_retries";
    public static final String DLQ = "dlq";
    private final String dlqFile;
    private final int maxRetries;
    private final DlqConfiguration dlq;

    public String getDlqFile() {
        return this.dlqFile;
    }

    public Optional<DlqConfiguration> getDlq() {
        return Optional.ofNullable(this.dlq);
    }

    public int getMaxRetries() {
        if (this.maxRetries < 1) {
            throw new IllegalArgumentException("max_retries must be > 1");
        }
        return this.maxRetries;
    }

    private RetryConfiguration(Builder builder) {
        this.dlqFile = builder.dlqFile;
        this.maxRetries = builder.maxRetries;
        this.dlq = builder.dlq;
    }

    public static RetryConfiguration readRetryConfig(OpenSearchSinkConfig openSearchSinkConfig) {
        DlqConfiguration dlqConfiguration;
        Integer maxRetries;
        Builder builder = new Builder();
        String dlqFile = openSearchSinkConfig.getDlqFile();
        if (dlqFile != null) {
            builder = builder.withDlqFile(dlqFile);
        }
        if ((maxRetries = openSearchSinkConfig.getMaxRetries()) != null) {
            builder = builder.withMaxRetries(maxRetries);
        }
        if ((dlqConfiguration = openSearchSinkConfig.getDlq()) != null) {
            builder = builder.withDlq(dlqConfiguration);
        }
        return builder.build();
    }

    public static class Builder {
        private String dlqFile;
        private int maxRetries = Integer.MAX_VALUE;
        private DlqConfiguration dlq;

        public Builder withDlqFile(String dlqFile) {
            Preconditions.checkNotNull((Object)dlqFile, (Object)"dlqFile cannot be null.");
            this.dlqFile = dlqFile;
            return this;
        }

        public Builder withMaxRetries(Integer maxRetries) {
            Preconditions.checkNotNull((Object)maxRetries, (Object)"maxRetries cannot be null.");
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder withDlq(DlqConfiguration dlq) {
            Preconditions.checkNotNull((Object)dlq, (Object)"dlq cannot be null");
            this.dlq = dlq;
            return this;
        }

        public RetryConfiguration build() {
            return new RetryConfiguration(this);
        }
    }
}

