/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.common.opensearch;

import java.time.Duration;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.plugins.common.opensearch.ServerlessNetworkPolicyUpdater;
import org.opensearch.dataprepper.plugins.sink.opensearch.ConnectionConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.configuration.AwsAuthenticationConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FullJitterBackoffStrategy;
import software.amazon.awssdk.services.opensearchserverless.OpenSearchServerlessClient;
import software.amazon.awssdk.services.opensearchserverless.OpenSearchServerlessClientBuilder;

public class ServerlessNetworkPolicyUpdaterFactory {
    public static ServerlessNetworkPolicyUpdater create(AwsCredentialsSupplier awsCredentialsSupplier, ConnectionConfiguration connectionConfiguration) {
        return new ServerlessNetworkPolicyUpdater(ServerlessNetworkPolicyUpdaterFactory.getOpenSearchServerlessClient(awsCredentialsSupplier, connectionConfiguration.createAwsCredentialsOptions()));
    }

    public static ServerlessNetworkPolicyUpdater create(AwsCredentialsSupplier awsCredentialsSupplier, AwsAuthenticationConfiguration awsConfig) {
        AwsCredentialsOptions awsCredentialsOptions = AwsCredentialsOptions.builder().withRegion(awsConfig.getAwsRegion()).withStsRoleArn(awsConfig.getAwsStsRoleArn()).withStsExternalId(awsConfig.getAwsStsExternalId()).withStsHeaderOverrides(awsConfig.getAwsStsHeaderOverrides()).build();
        return new ServerlessNetworkPolicyUpdater(ServerlessNetworkPolicyUpdaterFactory.getOpenSearchServerlessClient(awsCredentialsSupplier, awsCredentialsOptions));
    }

    private static OpenSearchServerlessClient getOpenSearchServerlessClient(AwsCredentialsSupplier awsCredentialsSupplier, AwsCredentialsOptions awsCredentialsOptions) {
        return (OpenSearchServerlessClient)((OpenSearchServerlessClientBuilder)((OpenSearchServerlessClientBuilder)((OpenSearchServerlessClientBuilder)OpenSearchServerlessClient.builder().credentialsProvider(awsCredentialsSupplier.getProvider(awsCredentialsOptions))).region(awsCredentialsOptions.getRegion())).overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(RetryPolicy.builder().backoffStrategy((BackoffStrategy)FullJitterBackoffStrategy.builder().baseDelay(Duration.ofSeconds(10L)).maxBackoffTime(Duration.ofSeconds(60L)).build()).numRetries(Integer.valueOf(10)).build()).build())).build();
    }
}

