/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.ml_inference.processor.dlq;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.failures.DlqObject;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.plugins.dlq.DlqProvider;
import org.opensearch.dataprepper.plugins.dlq.DlqWriter;
import org.opensearch.dataprepper.plugins.ml_inference.processor.configuration.AwsAuthenticationOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlqPushHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DlqPushHandler.class);
    public static final String STS_ROLE_ARN = "sts_role_arn";
    public static final String REGION = "region";
    private PluginSetting dlqPluginSetting;
    private DlqProvider dlqProvider;
    private DlqWriter dlqWriter;

    public DlqPushHandler(PluginFactory pluginFactory, PluginSetting pluginSetting, PluginModel dlqConfig, AwsAuthenticationOptions awsAuthenticationOptions) {
        this.dlqPluginSetting = new PluginSetting(dlqConfig.getPluginName(), dlqConfig.getPluginSettings());
        this.dlqPluginSetting.setPipelineName(pluginSetting.getPipelineName());
        Map dlqSettings = this.dlqPluginSetting.getSettings();
        boolean settingsChanged = false;
        if (!dlqSettings.containsKey(REGION) && awsAuthenticationOptions != null) {
            dlqSettings.put(REGION, String.valueOf(awsAuthenticationOptions.getAwsRegion()));
            settingsChanged = true;
        }
        if (!dlqSettings.containsKey(STS_ROLE_ARN) && awsAuthenticationOptions != null) {
            dlqSettings.put(STS_ROLE_ARN, String.valueOf(awsAuthenticationOptions.getAwsStsRoleArn()));
            settingsChanged = true;
        }
        if (settingsChanged) {
            LOG.info("Using AWS credentials from aws Auth Config");
            this.dlqPluginSetting.setSettings(dlqSettings);
        }
        this.dlqProvider = (DlqProvider)pluginFactory.loadPlugin(DlqProvider.class, this.dlqPluginSetting, new Object[0]);
        if (this.dlqProvider != null) {
            Optional potentialDlq = this.dlqProvider.getDlqWriter(new StringJoiner(".").add(pluginSetting.getPipelineName()).add(pluginSetting.getName()).toString());
            this.dlqWriter = potentialDlq.isPresent() ? (DlqWriter)potentialDlq.get() : null;
        }
    }

    public void perform(List<DlqObject> dlqObjects) throws Exception {
        if (this.dlqWriter != null && dlqObjects != null && dlqObjects.size() > 0) {
            this.dlqWriter.write(dlqObjects, this.dlqPluginSetting.getPipelineName(), this.dlqPluginSetting.getName());
            dlqObjects.forEach(dlqObject -> dlqObject.releaseEventHandle(true));
        }
    }

    public PluginSetting getDlqPluginSetting() {
        return this.dlqPluginSetting;
    }
}

