/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.HttpPreClient;
import com.linecorp.armeria.client.PreClient;
import com.linecorp.armeria.client.PreClientRequestContext;
import com.linecorp.armeria.client.RpcClient;
import com.linecorp.armeria.client.RpcPreClient;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.internal.client.ClientRequestContextExtension;
import com.linecorp.armeria.internal.client.ClientUtil;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class TailPreClient<I extends Request, O extends Response>
implements PreClient<I, O> {
    private final Client<I, O> delegate;
    private final Function<CompletableFuture<O>, O> futureConverter;
    private final BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory;

    private TailPreClient(Client<I, O> delegate, Function<CompletableFuture<O>, O> futureConverter, BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory) {
        this.delegate = delegate;
        this.futureConverter = futureConverter;
        this.errorResponseFactory = errorResponseFactory;
    }

    public static HttpPreClient of(HttpClient httpClient, Function<CompletableFuture<HttpResponse>, HttpResponse> futureConverter, BiFunction<ClientRequestContext, Throwable, HttpResponse> errorResponseFactory) {
        TailPreClient<HttpRequest, HttpResponse> tail = new TailPreClient<HttpRequest, HttpResponse>(httpClient, futureConverter, errorResponseFactory);
        return tail::execute;
    }

    public static RpcPreClient ofRpc(RpcClient rpcClient, Function<CompletableFuture<RpcResponse>, RpcResponse> futureConverter, BiFunction<ClientRequestContext, Throwable, RpcResponse> errorResponseFactory) {
        TailPreClient<RpcRequest, RpcResponse> tail = new TailPreClient<RpcRequest, RpcResponse>(rpcClient, futureConverter, errorResponseFactory);
        return tail::execute;
    }

    @Override
    public O execute(PreClientRequestContext ctx, I req) {
        ClientRequestContextExtension ctxExt = ctx.as(ClientRequestContextExtension.class);
        assert (ctxExt != null);
        return ClientUtil.initContextAndExecuteWithFallback(this.delegate, ctxExt, this.futureConverter, this.errorResponseFactory, req, true);
    }
}

