/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.obfuscation.action;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;

@JsonClassDescription(value="Obfuscates data by masking data. Without any configuration this will replace text with <code>***</code>")
@JsonPropertyOrder
public class MaskActionConfig {
    private static final String DEFAULT_MASK_CHARACTER = "*";
    private static final int DEFAULT_MASK_LENGTH = 3;
    @JsonProperty(value="mask_character", defaultValue="*")
    @Pattern(regexp="[*#!%&@]", message="Valid characters are *, #, $, %, &, ! and @")
    @JsonPropertyDescription(value="The character to use to mask text. By default, this is <code>*</code>. Valid characters are *, #, $, %, &, ! and @.")
    private @Pattern(regexp="[*#!%&@]", message="Valid characters are *, #, $, %, &, ! and @") String maskCharacter = "*";
    @JsonProperty(value="mask_character_length", defaultValue="3")
    @Min(value=1L)
    @Max(value=10L)
    @JsonPropertyDescription(value="The length of the character mask to apply. By default, this is three characters. The value must be between 1 and 10.")
    private @Min(value=1L) @Max(value=10L) int maskCharacterLength = 3;

    public MaskActionConfig() {
    }

    public MaskActionConfig(String maskCharacter, int maskCharacterLength) {
        this.maskCharacter = maskCharacter;
        this.maskCharacterLength = maskCharacterLength;
    }

    public String getMaskCharacter() {
        return this.maskCharacter;
    }

    public int getMaskCharacterLength() {
        return this.maskCharacterLength;
    }
}

