/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataLakeLifecycleTransition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataLakeLifecycleTransition> {
    private static final SdkField<Integer> DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("days").getter(DataLakeLifecycleTransition.getter(DataLakeLifecycleTransition::days)).setter(DataLakeLifecycleTransition.setter(Builder::days)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("days").build()}).build();
    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageClass").getter(DataLakeLifecycleTransition.getter(DataLakeLifecycleTransition::storageClass)).setter(DataLakeLifecycleTransition.setter(Builder::storageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageClass").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAYS_FIELD, STORAGE_CLASS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataLakeLifecycleTransition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer days;
    private final String storageClass;

    private DataLakeLifecycleTransition(BuilderImpl builder) {
        this.days = builder.days;
        this.storageClass = builder.storageClass;
    }

    public final Integer days() {
        return this.days;
    }

    public final String storageClass() {
        return this.storageClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.days());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClass());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeLifecycleTransition)) {
            return false;
        }
        DataLakeLifecycleTransition other = (DataLakeLifecycleTransition)obj;
        return Objects.equals(this.days(), other.days()) && Objects.equals(this.storageClass(), other.storageClass());
    }

    public final String toString() {
        return ToString.builder((String)"DataLakeLifecycleTransition").add("Days", (Object)this.days()).add("StorageClass", (Object)this.storageClass()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "days": {
                return Optional.ofNullable(clazz.cast(this.days()));
            }
            case "storageClass": {
                return Optional.ofNullable(clazz.cast(this.storageClass()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("days", DAYS_FIELD);
        map.put("storageClass", STORAGE_CLASS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLakeLifecycleTransition, T> g) {
        return obj -> g.apply((DataLakeLifecycleTransition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer days;
        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeLifecycleTransition model) {
            this.days(model.days);
            this.storageClass(model.storageClass);
        }

        public final Integer getDays() {
            return this.days;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public DataLakeLifecycleTransition build() {
            return new DataLakeLifecycleTransition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataLakeLifecycleTransition> {
        public Builder days(Integer var1);

        public Builder storageClass(String var1);
    }
}

