/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessRequest;
import software.amazon.awssdk.services.opensearchserverless.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.services.opensearchserverless.model.SubnetIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVpcEndpointRequest
extends OpenSearchServerlessRequest
implements ToCopyableBuilder<Builder, UpdateVpcEndpointRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateVpcEndpointRequest.getter(UpdateVpcEndpointRequest::id)).setter(UpdateVpcEndpointRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<String>> ADD_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addSubnetIds").getter(UpdateVpcEndpointRequest.getter(UpdateVpcEndpointRequest::addSubnetIds)).setter(UpdateVpcEndpointRequest.setter(Builder::addSubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addSubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("removeSubnetIds").getter(UpdateVpcEndpointRequest.getter(UpdateVpcEndpointRequest::removeSubnetIds)).setter(UpdateVpcEndpointRequest.setter(Builder::removeSubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeSubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADD_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addSecurityGroupIds").getter(UpdateVpcEndpointRequest.getter(UpdateVpcEndpointRequest::addSecurityGroupIds)).setter(UpdateVpcEndpointRequest.setter(Builder::addSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("removeSecurityGroupIds").getter(UpdateVpcEndpointRequest.getter(UpdateVpcEndpointRequest::removeSecurityGroupIds)).setter(UpdateVpcEndpointRequest.setter(Builder::removeSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateVpcEndpointRequest.getter(UpdateVpcEndpointRequest::clientToken)).setter(UpdateVpcEndpointRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ADD_SUBNET_IDS_FIELD, REMOVE_SUBNET_IDS_FIELD, ADD_SECURITY_GROUP_IDS_FIELD, REMOVE_SECURITY_GROUP_IDS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateVpcEndpointRequest.memberNameToFieldInitializer();
    private final String id;
    private final List<String> addSubnetIds;
    private final List<String> removeSubnetIds;
    private final List<String> addSecurityGroupIds;
    private final List<String> removeSecurityGroupIds;
    private final String clientToken;

    private UpdateVpcEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.addSubnetIds = builder.addSubnetIds;
        this.removeSubnetIds = builder.removeSubnetIds;
        this.addSecurityGroupIds = builder.addSecurityGroupIds;
        this.removeSecurityGroupIds = builder.removeSecurityGroupIds;
        this.clientToken = builder.clientToken;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasAddSubnetIds() {
        return this.addSubnetIds != null && !(this.addSubnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> addSubnetIds() {
        return this.addSubnetIds;
    }

    public final boolean hasRemoveSubnetIds() {
        return this.removeSubnetIds != null && !(this.removeSubnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> removeSubnetIds() {
        return this.removeSubnetIds;
    }

    public final boolean hasAddSecurityGroupIds() {
        return this.addSecurityGroupIds != null && !(this.addSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> addSecurityGroupIds() {
        return this.addSecurityGroupIds;
    }

    public final boolean hasRemoveSecurityGroupIds() {
        return this.removeSecurityGroupIds != null && !(this.removeSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> removeSecurityGroupIds() {
        return this.removeSecurityGroupIds;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddSubnetIds() ? this.addSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveSubnetIds() ? this.removeSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddSecurityGroupIds() ? this.addSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveSecurityGroupIds() ? this.removeSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcEndpointRequest)) {
            return false;
        }
        UpdateVpcEndpointRequest other = (UpdateVpcEndpointRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && this.hasAddSubnetIds() == other.hasAddSubnetIds() && Objects.equals(this.addSubnetIds(), other.addSubnetIds()) && this.hasRemoveSubnetIds() == other.hasRemoveSubnetIds() && Objects.equals(this.removeSubnetIds(), other.removeSubnetIds()) && this.hasAddSecurityGroupIds() == other.hasAddSecurityGroupIds() && Objects.equals(this.addSecurityGroupIds(), other.addSecurityGroupIds()) && this.hasRemoveSecurityGroupIds() == other.hasRemoveSecurityGroupIds() && Objects.equals(this.removeSecurityGroupIds(), other.removeSecurityGroupIds()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateVpcEndpointRequest").add("Id", (Object)this.id()).add("AddSubnetIds", this.hasAddSubnetIds() ? this.addSubnetIds() : null).add("RemoveSubnetIds", this.hasRemoveSubnetIds() ? this.removeSubnetIds() : null).add("AddSecurityGroupIds", this.hasAddSecurityGroupIds() ? this.addSecurityGroupIds() : null).add("RemoveSecurityGroupIds", this.hasRemoveSecurityGroupIds() ? this.removeSecurityGroupIds() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "addSubnetIds": {
                return Optional.ofNullable(clazz.cast(this.addSubnetIds()));
            }
            case "removeSubnetIds": {
                return Optional.ofNullable(clazz.cast(this.removeSubnetIds()));
            }
            case "addSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.addSecurityGroupIds()));
            }
            case "removeSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.removeSecurityGroupIds()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("addSubnetIds", ADD_SUBNET_IDS_FIELD);
        map.put("removeSubnetIds", REMOVE_SUBNET_IDS_FIELD);
        map.put("addSecurityGroupIds", ADD_SECURITY_GROUP_IDS_FIELD);
        map.put("removeSecurityGroupIds", REMOVE_SECURITY_GROUP_IDS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcEndpointRequest, T> g) {
        return obj -> g.apply((UpdateVpcEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessRequest.BuilderImpl
    implements Builder {
        private String id;
        private List<String> addSubnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeSubnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> addSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcEndpointRequest model) {
            super(model);
            this.id(model.id);
            this.addSubnetIds(model.addSubnetIds);
            this.removeSubnetIds(model.removeSubnetIds);
            this.addSecurityGroupIds(model.addSecurityGroupIds);
            this.removeSecurityGroupIds(model.removeSecurityGroupIds);
            this.clientToken(model.clientToken);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<String> getAddSubnetIds() {
            if (this.addSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addSubnetIds;
        }

        public final void setAddSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = SubnetIdsCopier.copy(addSubnetIds);
        }

        @Override
        public final Builder addSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = SubnetIdsCopier.copy(addSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSubnetIds(String ... addSubnetIds) {
            this.addSubnetIds(Arrays.asList(addSubnetIds));
            return this;
        }

        public final Collection<String> getRemoveSubnetIds() {
            if (this.removeSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeSubnetIds;
        }

        public final void setRemoveSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = SubnetIdsCopier.copy(removeSubnetIds);
        }

        @Override
        public final Builder removeSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = SubnetIdsCopier.copy(removeSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSubnetIds(String ... removeSubnetIds) {
            this.removeSubnetIds(Arrays.asList(removeSubnetIds));
            return this;
        }

        public final Collection<String> getAddSecurityGroupIds() {
            if (this.addSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addSecurityGroupIds;
        }

        public final void setAddSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = SecurityGroupIdsCopier.copy(addSecurityGroupIds);
        }

        @Override
        public final Builder addSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = SecurityGroupIdsCopier.copy(addSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSecurityGroupIds(String ... addSecurityGroupIds) {
            this.addSecurityGroupIds(Arrays.asList(addSecurityGroupIds));
            return this;
        }

        public final Collection<String> getRemoveSecurityGroupIds() {
            if (this.removeSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeSecurityGroupIds;
        }

        public final void setRemoveSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = SecurityGroupIdsCopier.copy(removeSecurityGroupIds);
        }

        @Override
        public final Builder removeSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = SecurityGroupIdsCopier.copy(removeSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSecurityGroupIds(String ... removeSecurityGroupIds) {
            this.removeSecurityGroupIds(Arrays.asList(removeSecurityGroupIds));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVpcEndpointRequest build() {
            return new UpdateVpcEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVpcEndpointRequest> {
        public Builder id(String var1);

        public Builder addSubnetIds(Collection<String> var1);

        public Builder addSubnetIds(String ... var1);

        public Builder removeSubnetIds(Collection<String> var1);

        public Builder removeSubnetIds(String ... var1);

        public Builder addSecurityGroupIds(Collection<String> var1);

        public Builder addSecurityGroupIds(String ... var1);

        public Builder removeSecurityGroupIds(Collection<String> var1);

        public Builder removeSecurityGroupIds(String ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

