/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;

public class IOUtils {
    private static final int BUFFER_SIZE = 4096;

    public static byte[] toByteArray(InputStream is) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            byte[] b = new byte[4096];
            int n = 0;
            while ((n = is.read(b)) != -1) {
                output.write(b, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static String toString(InputStream is) throws IOException {
        return new String(IOUtils.toByteArray(is), StandardCharsets.UTF_8);
    }

    public static void closeQuietly(Closeable is, Logger log) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException ex) {
                log.debug("Ignore failure in closing the Closeable", (Throwable)ex);
            }
        }
    }
}

