/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.sinks.retry;

import java.util.concurrent.ThreadLocalRandom;
import org.javatuples.Pair;
import software.amazon.cloudwatchlogs.emf.sinks.retry.RetryStrategy;

public class FibonacciRetryStrategy
implements RetryStrategy {
    private final int maxJitter;
    private final int upperBound;
    Pair<Integer, Integer> cursor;

    public FibonacciRetryStrategy(int start, int upperBound, int maxJitter) {
        this.cursor = new Pair((Object)start, (Object)start);
        this.upperBound = upperBound;
        this.maxJitter = maxJitter;
    }

    @Override
    public int next() {
        int nextValue = (Integer)this.cursor.getValue0() + (Integer)this.cursor.getValue1();
        this.cursor = (Integer)this.cursor.getValue1() >= this.upperBound ? new Pair((Object)this.upperBound, (Object)this.upperBound) : new Pair((Object)((Integer)this.cursor.getValue1()), (Object)nextValue);
        int jitter = this.maxJitter > 0 ? ThreadLocalRandom.current().nextInt(this.maxJitter) : 0;
        return (Integer)this.cursor.getValue0() + jitter;
    }
}

