/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.RiskDetection;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RiskDetectionRequest
extends BaseRequest<RiskDetection> {
    public RiskDetectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RiskDetection.class);
    }

    @Nonnull
    public CompletableFuture<RiskDetection> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public RiskDetection get() throws ClientException {
        return (RiskDetection)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<RiskDetection> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public RiskDetection delete() throws ClientException {
        return (RiskDetection)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<RiskDetection> patchAsync(@Nonnull RiskDetection sourceRiskDetection) {
        return this.sendAsync(HttpMethod.PATCH, sourceRiskDetection);
    }

    @Nullable
    public RiskDetection patch(@Nonnull RiskDetection sourceRiskDetection) throws ClientException {
        return (RiskDetection)this.send(HttpMethod.PATCH, sourceRiskDetection);
    }

    @Nonnull
    public CompletableFuture<RiskDetection> postAsync(@Nonnull RiskDetection newRiskDetection) {
        return this.sendAsync(HttpMethod.POST, newRiskDetection);
    }

    @Nullable
    public RiskDetection post(@Nonnull RiskDetection newRiskDetection) throws ClientException {
        return (RiskDetection)this.send(HttpMethod.POST, newRiskDetection);
    }

    @Nonnull
    public CompletableFuture<RiskDetection> putAsync(@Nonnull RiskDetection newRiskDetection) {
        return this.sendAsync(HttpMethod.PUT, newRiskDetection);
    }

    @Nullable
    public RiskDetection put(@Nonnull RiskDetection newRiskDetection) throws ClientException {
        return (RiskDetection)this.send(HttpMethod.PUT, newRiskDetection);
    }

    @Nonnull
    public RiskDetectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public RiskDetectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

