/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Domain;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DomainRequest
extends BaseRequest<Domain> {
    public DomainRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Domain.class);
    }

    @Nonnull
    public CompletableFuture<Domain> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Domain get() throws ClientException {
        return (Domain)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Domain> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Domain delete() throws ClientException {
        return (Domain)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Domain> patchAsync(@Nonnull Domain sourceDomain) {
        return this.sendAsync(HttpMethod.PATCH, sourceDomain);
    }

    @Nullable
    public Domain patch(@Nonnull Domain sourceDomain) throws ClientException {
        return (Domain)this.send(HttpMethod.PATCH, sourceDomain);
    }

    @Nonnull
    public CompletableFuture<Domain> postAsync(@Nonnull Domain newDomain) {
        return this.sendAsync(HttpMethod.POST, newDomain);
    }

    @Nullable
    public Domain post(@Nonnull Domain newDomain) throws ClientException {
        return (Domain)this.send(HttpMethod.POST, newDomain);
    }

    @Nonnull
    public CompletableFuture<Domain> putAsync(@Nonnull Domain newDomain) {
        return this.sendAsync(HttpMethod.PUT, newDomain);
    }

    @Nullable
    public Domain put(@Nonnull Domain newDomain) throws ClientException {
        return (Domain)this.send(HttpMethod.PUT, newDomain);
    }

    @Nonnull
    public DomainRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DomainRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

