/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.AttributeSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.AttributeSetCollectionPage;
import com.microsoft.graph.requests.AttributeSetCollectionRequestBuilder;
import com.microsoft.graph.requests.AttributeSetCollectionResponse;
import com.microsoft.graph.requests.AttributeSetRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AttributeSetCollectionRequest
extends BaseEntityCollectionRequest<AttributeSet, AttributeSetCollectionResponse, AttributeSetCollectionPage> {
    public AttributeSetCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AttributeSetCollectionResponse.class, AttributeSetCollectionPage.class, AttributeSetCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<AttributeSet> postAsync(@Nonnull AttributeSet newAttributeSet) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AttributeSetRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newAttributeSet);
    }

    @Nonnull
    public AttributeSet post(@Nonnull AttributeSet newAttributeSet) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AttributeSetRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAttributeSet);
    }

    @Nonnull
    public AttributeSetCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public AttributeSetCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public AttributeSetCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public AttributeSetCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public AttributeSetCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public AttributeSetCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public AttributeSetCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public AttributeSetCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public AttributeSetCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

