/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.models.Application;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ApplicationCollectionResponse;
import com.microsoft.graph.requests.ApplicationCollectionWithReferencesPage;
import com.microsoft.graph.requests.ApplicationCollectionWithReferencesRequest;
import com.microsoft.graph.requests.ApplicationCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ApplicationReferenceRequestBuilder;
import com.microsoft.graph.requests.ApplicationWithReferenceRequest;
import com.microsoft.graph.requests.ApplicationWithReferenceRequestBuilder;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplicationCollectionReferenceRequest
extends BaseCollectionWithReferencesRequest<Application, ApplicationWithReferenceRequest, ApplicationReferenceRequestBuilder, ApplicationWithReferenceRequestBuilder, ApplicationCollectionResponse, ApplicationCollectionWithReferencesPage, ApplicationCollectionWithReferencesRequest> {
    public ApplicationCollectionReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ApplicationCollectionResponse.class, ApplicationCollectionWithReferencesPage.class, ApplicationCollectionWithReferencesRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Application> postAsync(@Nonnull Application newApplication) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/applications/" + newApplication.id);
        return ((ApplicationWithReferenceRequest)new ApplicationWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders())).postAsync(newApplication, (IJsonBackedObject)body);
    }

    @Nonnull
    public Application post(@Nonnull Application newApplication) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/applications/" + newApplication.id);
        return (Application)((ApplicationWithReferenceRequest)new ApplicationWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders())).post(newApplication, (IJsonBackedObject)body);
    }

    @Nonnull
    public ApplicationCollectionReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ApplicationCollectionReferenceRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ApplicationCollectionReferenceRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ApplicationCollectionReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ApplicationCollectionReferenceRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ApplicationCollectionReferenceRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ApplicationCollectionReferenceRequest count() {
        this.addCountOption(true);
        return this;
    }
}

