/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.FunctionUrlConfig;
import software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse;

public class ListFunctionUrlConfigsPublisher
implements SdkPublisher<ListFunctionUrlConfigsResponse> {
    private final LambdaAsyncClient client;
    private final ListFunctionUrlConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFunctionUrlConfigsPublisher(LambdaAsyncClient client, ListFunctionUrlConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFunctionUrlConfigsPublisher(LambdaAsyncClient client, ListFunctionUrlConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFunctionUrlConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFunctionUrlConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FunctionUrlConfig> functionUrlConfigs() {
        Function<ListFunctionUrlConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.functionUrlConfigs() != null) {
                return response.functionUrlConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFunctionUrlConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFunctionUrlConfigsResponseFetcher
    implements AsyncPageFetcher<ListFunctionUrlConfigsResponse> {
        private ListFunctionUrlConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListFunctionUrlConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListFunctionUrlConfigsResponse> nextPage(ListFunctionUrlConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListFunctionUrlConfigsPublisher.this.client.listFunctionUrlConfigs(ListFunctionUrlConfigsPublisher.this.firstRequest);
            }
            return ListFunctionUrlConfigsPublisher.this.client.listFunctionUrlConfigs((ListFunctionUrlConfigsRequest)((Object)ListFunctionUrlConfigsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

