/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source;

import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.plugins.source.RandomStringSourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="random", pluginType=Source.class, pluginConfigurationType=RandomStringSourceConfig.class)
public class RandomStringSource
implements Source<Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(RandomStringSource.class);
    private static final int BUFFER_WAIT = 500;
    private final long waitTimeInMillis;
    private volatile boolean stop = false;
    private Thread thread;

    @DataPrepperPluginConstructor
    public RandomStringSource(RandomStringSourceConfig config) {
        this.waitTimeInMillis = config.getWaitDelay().toMillis();
    }

    public void start(Buffer<Record<Event>> buffer) {
        if (this.thread != null) {
            throw new IllegalStateException("This source has already started.");
        }
        this.thread = new Thread(() -> {
            while (!this.stop) {
                try {
                    LOG.debug("Writing to buffer");
                    Record<Event> record = this.generateRandomStringEventRecord();
                    buffer.write(record, 500);
                    Thread.sleep(this.waitTimeInMillis);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (TimeoutException timeoutException) {
                }
            }
        }, "random-source");
        this.thread.setDaemon(false);
        this.thread.start();
    }

    public void stop() {
        this.stop = true;
        try {
            this.thread.join(this.waitTimeInMillis + 500L + 100L);
        }
        catch (InterruptedException e) {
            this.thread.interrupt();
        }
    }

    private Record<Event> generateRandomStringEventRecord() {
        Event event = JacksonEvent.fromMessage((String)UUID.randomUUID().toString());
        return new Record((Object)event);
    }
}

