/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="string_converter", pluginType=Processor.class, pluginConfigurationType=Configuration.class)
public class StringProcessor
implements Processor<Record<Event>, Record<Event>> {
    private static Logger LOG = LoggerFactory.getLogger(StringProcessor.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final TypeReference<Map<String, Object>> mapTypeReference = new TypeReference<Map<String, Object>>(){};
    public static final String UPPER_CASE = "upper_case";
    private final boolean upperCase;

    @DataPrepperPluginConstructor
    public StringProcessor(Configuration configuration) {
        this.upperCase = configuration.getUpperCase();
    }

    public Collection<Record<Event>> execute(Collection<Record<Event>> records) {
        ArrayList<Record<Event>> modifiedRecords = new ArrayList<Record<Event>>(records.size());
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            String eventJson = recordEvent.toJsonString();
            try {
                Map<String, Object> newData = this.processEventJson(eventJson);
                JacksonEvent newRecordEvent = JacksonEvent.builder().withEventMetadata(recordEvent.getMetadata()).withData(newData).build();
                modifiedRecords.add((Record<Event>)new Record((Object)newRecordEvent));
            }
            catch (JsonProcessingException e) {
                LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("Unable to process Event data: {}").addArgument((Object)eventJson).setCause((Throwable)e).log();
            }
        }
        return modifiedRecords;
    }

    private Map<String, Object> processEventJson(String data) throws JsonProcessingException {
        Map dataMap = (Map)this.objectMapper.readValue(data, this.mapTypeReference);
        return dataMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Object val = entry.getValue();
            if (val instanceof String) {
                return this.upperCase ? ((String)val).toUpperCase() : ((String)val).toLowerCase();
            }
            return val;
        }));
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }

    @JsonPropertyOrder
    @JsonClassDescription(value="The <code>string_converter</code> processor converts a string to uppercase or lowercase.")
    public static class Configuration {
        @JsonPropertyDescription(value="Whether to convert to uppercase (<code>true</code>) or lowercase (<code>false</code>).")
        private boolean upperCase = true;

        public boolean getUpperCase() {
            return this.upperCase;
        }

        public void setUpperCase(boolean upperCase) {
            this.upperCase = upperCase;
        }
    }
}

