/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.opensearch.dataprepper.model.codec.DecompressionEngine;

public class GZipDecompressionEngine
implements DecompressionEngine {
    public InputStream createInputStream(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackStream = new PushbackInputStream(inputStream, 2);
        byte[] signature = new byte[2];
        int len = pushbackStream.read(signature);
        pushbackStream.unread(signature, 0, len);
        if (!GzipCompressorInputStream.matches((byte[])signature, (int)len)) {
            throw new IOException("GZIP encoding specified but data did contain gzip magic header");
        }
        return new GzipCompressorInputStream((InputStream)pushbackStream, true);
    }
}

