/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.utils;

import io.micrometer.core.instrument.Counter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

public class MetricsHelper {
    private static final String REQUEST_ACCESS_DENIED = "requestAccessDenied";
    private static final String REQUEST_THROTTLED = "requestThrottled";
    private static final String RESOURCE_NOT_FOUND = "resourceNotFound";
    public static final String REQUEST_ERRORS = "requestErrors";

    public static Map<String, Counter> getErrorTypeMetricCounterMap(PluginMetrics pluginMetrics) {
        HashMap<String, Counter> errorTypeMetricCounterMap = new HashMap<String, Counter>();
        errorTypeMetricCounterMap.put(HttpStatus.FORBIDDEN.getReasonPhrase(), pluginMetrics.counter(REQUEST_ACCESS_DENIED));
        errorTypeMetricCounterMap.put(HttpStatus.UNAUTHORIZED.getReasonPhrase(), pluginMetrics.counter(REQUEST_ACCESS_DENIED));
        errorTypeMetricCounterMap.put(HttpStatus.TOO_MANY_REQUESTS.getReasonPhrase(), pluginMetrics.counter(REQUEST_THROTTLED));
        errorTypeMetricCounterMap.put(HttpStatus.NOT_FOUND.getReasonPhrase(), pluginMetrics.counter(RESOURCE_NOT_FOUND));
        return errorTypeMetricCounterMap;
    }

    public static void publishErrorTypeMetricCounter(Exception ex, Map<String, Counter> errorTypeMetricCounterMap) {
        HttpClientErrorException httpE;
        Optional<Object> statusCode = Optional.empty();
        if (ex instanceof HttpClientErrorException) {
            httpE = (HttpClientErrorException)ex;
            statusCode = Optional.ofNullable(httpE.getStatusCode().getReasonPhrase());
        } else if (ex instanceof HttpServerErrorException) {
            httpE = (HttpServerErrorException)ex;
            statusCode = Optional.ofNullable(httpE.getStatusCode().getReasonPhrase());
        } else if (ex instanceof SecurityException) {
            statusCode = Optional.ofNullable(HttpStatus.FORBIDDEN.getReasonPhrase());
        }
        if (statusCode.isPresent()) {
            String errorType = (String)statusCode.get();
            if (errorTypeMetricCounterMap != null && errorTypeMetricCounterMap.containsKey(errorType)) {
                errorTypeMetricCounterMap.get(errorType).increment();
            }
        }
    }
}

