/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.coordination.partition;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.LeaderProgressState;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.TokenLeaderProgressState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderPartition
extends EnhancedSourcePartition<LeaderProgressState> {
    public static final String PARTITION_TYPE = "LEADER";
    public static final String DEFAULT_PARTITION_KEY = "GLOBAL";
    private static final Logger LOG = LoggerFactory.getLogger(LeaderPartition.class);
    private static final ObjectMapper objectMapper = new ObjectMapper(new JsonFactory()).registerModule((Module)new JavaTimeModule());
    private final LeaderProgressState state;

    public LeaderPartition(LeaderProgressState state) {
        this.state = state;
    }

    public LeaderPartition(SourcePartitionStoreItem sourcePartitionStoreItem) {
        this.setSourcePartitionStoreItem(sourcePartitionStoreItem);
        this.state = this.convertToPartitionState(sourcePartitionStoreItem.getPartitionProgressState());
    }

    public String getPartitionType() {
        return PARTITION_TYPE;
    }

    public String getPartitionKey() {
        return DEFAULT_PARTITION_KEY;
    }

    public Optional<LeaderProgressState> getProgressState() {
        return Optional.of(this.state);
    }

    public void setLeaderProgressState(LeaderProgressState state) {
        boolean stateIsToken = state instanceof TokenLeaderProgressState;
        boolean thisStateIsToken = this.state instanceof TokenLeaderProgressState;
        if (stateIsToken != thisStateIsToken) {
            throw new RuntimeException("Leader partition progress state type mismatch: Provided state type: " + state.getClass().getSimpleName() + ", Current state type: " + this.state.getClass().getSimpleName());
        }
        if (state instanceof TokenLeaderProgressState) {
            ((TokenLeaderProgressState)((Object)this.state)).setLastToken(((TokenLeaderProgressState)((Object)state)).getLastToken());
        } else {
            this.state.setLastPollTime(state.getLastPollTime());
        }
    }

    public LeaderProgressState convertToPartitionState(String serializedPartitionProgressState) {
        if (Objects.isNull(serializedPartitionProgressState)) {
            return null;
        }
        try {
            return (LeaderProgressState)objectMapper.readValue(serializedPartitionProgressState, LeaderProgressState.class);
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to convert string to partition progress state class due to {}.  Partition progress state string: {}.", (Object)e.getMessage(), (Object)serializedPartitionProgressState);
            return null;
        }
    }
}

