/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.base;

import io.micrometer.core.instrument.Counter;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import javax.inject.Named;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.Crawler;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerClient;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.LeaderProgressState;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.SaasWorkerProgressState;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.partition.LeaderPartition;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.partition.SaasSourcePartition;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.scheduler.LeaderScheduler;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.state.CrowdStrikeLeaderProgressState;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.state.CrowdStrikeWorkerProgressState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class TimeSliceCrawler
implements Crawler {
    private static final Logger log = LoggerFactory.getLogger(TimeSliceCrawler.class);
    private static final String TIME_SLICE_WORKER_PARTITIONS_CREATED = "TimeSliceWorkerPartitionsCreated";
    private final CrawlerClient client;
    private final Counter partitionsCreatedCounter;
    private static final String LAST_UPDATED_KEY = "last_updated|";

    public TimeSliceCrawler(CrawlerClient client, PluginMetrics pluginMetrics) {
        this.client = client;
        this.partitionsCreatedCounter = pluginMetrics.counter(TIME_SLICE_WORKER_PARTITIONS_CREATED);
    }

    @Override
    public Instant crawl(LeaderPartition leaderPartition, EnhancedSourceCoordinator coordinator) {
        Instant latestModifiedTime = Instant.now();
        double startCount = this.partitionsCreatedCounter.count();
        this.createPartitionForCrawling(leaderPartition, coordinator, latestModifiedTime);
        double partitionsInThisCrawl = this.partitionsCreatedCounter.count() - startCount;
        log.info("Total partitions created in this crawl: {}", (Object)partitionsInThisCrawl);
        return latestModifiedTime;
    }

    public void executePartition(SaasWorkerProgressState state, Buffer buffer, AcknowledgementSet acknowledgementSet) {
        this.client.executePartition(state, (Buffer<Record<Event>>)buffer, acknowledgementSet);
    }

    private void createPartitionForCrawling(LeaderPartition leaderPartition, EnhancedSourceCoordinator coordinator, Instant latestModifiedTime) {
        CrowdStrikeLeaderProgressState leaderProgressState = (CrowdStrikeLeaderProgressState)leaderPartition.getProgressState().get();
        if (leaderProgressState.getRemainingDays() == 0) {
            this.createPartitionForIncrementalSync(leaderPartition, coordinator, latestModifiedTime);
        } else {
            this.createPartitionForHistoricalPull(leaderPartition, coordinator, latestModifiedTime);
        }
    }

    private void updateLeaderProgressState(LeaderPartition leaderPartition, int remainingDays, Instant updatedPollTime, EnhancedSourceCoordinator coordinator) {
        CrowdStrikeLeaderProgressState state = (CrowdStrikeLeaderProgressState)leaderPartition.getProgressState().get();
        state.setRemainingDays(remainingDays);
        state.setLastPollTime(updatedPollTime);
        leaderPartition.setLeaderProgressState(state);
        coordinator.saveProgressStateForPartition((EnhancedSourcePartition)leaderPartition, LeaderScheduler.DEFAULT_EXTEND_LEASE_MINUTES);
    }

    private void createPartitionForIncrementalSync(LeaderPartition leaderPartition, EnhancedSourceCoordinator coordinator, Instant latestModifiedTime) {
        LeaderProgressState leaderProgressState = leaderPartition.getProgressState().get();
        this.createWorkerPartition(leaderProgressState.getLastPollTime(), latestModifiedTime, coordinator);
        this.updateLeaderProgressState(leaderPartition, 0, latestModifiedTime, coordinator);
    }

    private void createPartitionForHistoricalPull(LeaderPartition leaderPartition, EnhancedSourceCoordinator coordinator, Instant latestModifiedTime) {
        CrowdStrikeLeaderProgressState leaderProgressState = (CrowdStrikeLeaderProgressState)leaderPartition.getProgressState().get();
        int remainingDays = leaderProgressState.getRemainingDays();
        Instant initialDate = leaderProgressState.getLastPollTime();
        Instant todayUtc = initialDate.truncatedTo(ChronoUnit.DAYS);
        for (int i = remainingDays; i > 0; --i) {
            Instant startDate = todayUtc.minus(Duration.ofDays(i));
            this.createWorkerPartition(startDate, startDate.plus(Duration.ofDays(1L)), coordinator);
        }
        this.createWorkerPartition(todayUtc, latestModifiedTime, coordinator);
        this.updateLeaderProgressState(leaderPartition, 0, latestModifiedTime, coordinator);
    }

    void createWorkerPartition(Instant startTime, Instant endTime, EnhancedSourceCoordinator coordinator) {
        CrowdStrikeWorkerProgressState workerState = new CrowdStrikeWorkerProgressState();
        workerState.setStartTime(startTime);
        workerState.setEndTime(endTime);
        SaasSourcePartition partition = new SaasSourcePartition(workerState, LAST_UPDATED_KEY + String.valueOf(UUID.randomUUID()));
        coordinator.createPartition((EnhancedSourcePartition)partition);
        this.partitionsCreatedCounter.increment();
        log.info("Created partition from {} to {}", (Object)startTime, (Object)endTime);
    }
}

