/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins;

import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.auth.AuthService;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.opensearch.dataprepper.armeria.authentication.ArmeriaHttpAuthenticationProvider;
import org.opensearch.dataprepper.armeria.authentication.HttpBasicAuthenticationConfig;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;

@DataPrepperPlugin(name="http_basic", pluginType=ArmeriaHttpAuthenticationProvider.class, pluginConfigurationType=HttpBasicAuthenticationConfig.class)
public class HttpBasicArmeriaHttpAuthenticationProvider
implements ArmeriaHttpAuthenticationProvider {
    private final HttpBasicAuthenticationConfig httpBasicAuthenticationConfig;

    @DataPrepperPluginConstructor
    public HttpBasicArmeriaHttpAuthenticationProvider(HttpBasicAuthenticationConfig httpBasicAuthenticationConfig) {
        Objects.requireNonNull(httpBasicAuthenticationConfig);
        Objects.requireNonNull(httpBasicAuthenticationConfig.getUsername());
        Objects.requireNonNull(httpBasicAuthenticationConfig.getPassword());
        this.httpBasicAuthenticationConfig = httpBasicAuthenticationConfig;
    }

    @Override
    public Optional<Function<? super HttpService, ? extends HttpService>> getAuthenticationDecorator() {
        return Optional.of(this.createDecorator());
    }

    private Function<? super HttpService, ? extends HttpService> createDecorator() {
        return AuthService.builder().addBasicAuth((context, basic) -> CompletableFuture.completedFuture(this.httpBasicAuthenticationConfig.getUsername().equals(basic.username()) && this.httpBasicAuthenticationConfig.getPassword().equals(basic.password()))).newDecorator();
    }
}

