/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.translate;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.opensearch.dataprepper.plugins.processor.translate.MappingsHandler;
import org.opensearch.dataprepper.plugins.processor.translate.MappingsParameterConfig;
import org.opensearch.dataprepper.plugins.processor.translate.S3ObjectConfig;

public class FileParameterConfig {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The full path to a local file or key name for an S3 object.")
    @NotNull
    private String fileName;
    @JsonProperty(value="aws")
    @JsonPropertyDescription(value="The AWS configuration when the file is an S3 object.")
    @Valid
    private S3ObjectConfig awsConfig;

    public String getFileName() {
        return this.fileName;
    }

    public S3ObjectConfig getAwsConfig() {
        return this.awsConfig;
    }

    public List<MappingsParameterConfig> getFileMappings() {
        MappingsHandler handler = new MappingsHandler();
        if (this.awsConfig != null) {
            return handler.getS3FileMappings(this.awsConfig, this.fileName);
        }
        return handler.getMappingsFromFilePath(this.fileName);
    }
}

