/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.event.DataType;
import org.opensearch.dataprepper.typeconverter.BigDecimalConverter;
import org.opensearch.dataprepper.typeconverter.BooleanConverter;
import org.opensearch.dataprepper.typeconverter.DoubleConverter;
import org.opensearch.dataprepper.typeconverter.IntegerConverter;
import org.opensearch.dataprepper.typeconverter.LongConverter;
import org.opensearch.dataprepper.typeconverter.StringConverter;
import org.opensearch.dataprepper.typeconverter.TypeConverter;

public enum TargetType {
    INTEGER(DataType.INTEGER, (TypeConverter<?>)new IntegerConverter()),
    STRING(DataType.STRING, (TypeConverter<?>)new StringConverter()),
    DOUBLE(DataType.DOUBLE, (TypeConverter<?>)new DoubleConverter()),
    BOOLEAN(DataType.BOOLEAN, (TypeConverter<?>)new BooleanConverter()),
    LONG(DataType.LONG, (TypeConverter<?>)new LongConverter()),
    BIG_DECIMAL(DataType.BIG_DECIMAL, (TypeConverter<?>)new BigDecimalConverter());

    private static final Map<DataType, TargetType> OPTIONS_MAP;
    private final DataType dataType;
    private final TypeConverter<?> targetConverter;

    private TargetType(DataType dataType, TypeConverter<?> target) {
        this.dataType = dataType;
        this.targetConverter = target;
    }

    public TypeConverter<?> getTargetConverter() {
        return this.targetConverter;
    }

    DataType getDataType() {
        return this.dataType;
    }

    @JsonCreator
    public static TargetType fromOptionValue(String option) {
        return OPTIONS_MAP.get(DataType.fromTypeName((String)option));
    }

    @JsonValue
    public String getOptionValue() {
        return this.dataType.getTypeName();
    }

    static {
        OPTIONS_MAP = Arrays.stream(TargetType.values()).collect(Collectors.toMap(value -> value.dataType, value -> value));
    }
}

