/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import java.util.List;
import java.util.Optional;
import org.opensearch.dataprepper.model.annotations.AlsoRequired;
import org.opensearch.dataprepper.model.annotations.ConditionalRequired;
import org.opensearch.dataprepper.model.annotations.ExampleValues;
import org.opensearch.dataprepper.plugins.processor.mutateevent.TargetType;
import org.opensearch.dataprepper.typeconverter.ConverterArguments;

@ConditionalRequired(value={@ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="autoInferStringValues", value="true")}, thenExpect={}), @ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="key", value="null"), @ConditionalRequired.SchemaProperty(field="autoInferStringValues", value="false")}, thenExpect={@ConditionalRequired.SchemaProperty(field="keys")}), @ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="keys", value="null"), @ConditionalRequired.SchemaProperty(field="autoInferStringValues", value="false")}, thenExpect={@ConditionalRequired.SchemaProperty(field="key")})})
@JsonPropertyOrder
@JsonClassDescription(value="The <code>convert_type</code> processor converts a value associated with the specified key in a event to the specified type. It is a casting processor that changes the types of specified fields in events.")
public class ConvertEntryTypeProcessorConfig
implements ConverterArguments {
    public static final List<String> DEFAULT_TIME_STRING_FORMATS = List.of("MMM d HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "yyyy-MM-dd'T'HH:mm:ss.SSSSSSX", "dd/MMM/yyyy:HH:mm:ss Z");
    static final String KEY_KEY = "key";
    static final String KEYS_KEY = "keys";
    @JsonProperty(value="key")
    @JsonPropertyDescription(value="Key whose value needs to be converted to a different type. Cannot be declared at the same time as <code>keys</code>.")
    @AlsoRequired(values={@AlsoRequired.Required(name="keys", allowedValues={"null"})})
    private String key;
    @JsonProperty(value="keys")
    @JsonPropertyDescription(value="List of keys whose values needs to be converted to a different type. Cannot be declared at the same time as <code>key</code>.")
    @AlsoRequired(values={@AlsoRequired.Required(name="key", allowedValues={"null"})})
    private List<String> keys;
    @JsonProperty(value="type", defaultValue="integer")
    @JsonPropertyDescription(value="Target type for the values. Default value is <code>integer</code>.")
    private TargetType type = TargetType.INTEGER;
    @JsonProperty(value="null_conversion_values")
    @JsonAlias(value={"null_values"})
    @JsonPropertyDescription(value="String representation of what constitutes a null value. If the field value equals one of these strings, then the value is considered null and is converted to null.")
    private List<String> nullValues;
    @JsonProperty(value="coerce_strings")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private CoerceStringsConfig coerceStrings = null;
    @JsonProperty(value="scale", defaultValue="0")
    @JsonPropertyDescription(value="Modifies the scale of the <code>big_decimal</code> when converting to a <code>big_decimal</code>. The default value is 0.")
    private int scale = 0;
    @JsonProperty(value="tags_on_failure")
    @JsonPropertyDescription(value="A list of tags to be added to the event metadata when the event fails to convert.")
    private List<String> tagsOnFailure;
    @JsonProperty(value="convert_when")
    @JsonPropertyDescription(value="Specifies a condition using a <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a> for performing the <code>convert_type</code> operation. If specified, the <code>convert_type</code> operation runs only when the expression evaluates to true. Example: <code>/mykey != \"test\"</code>")
    @ExampleValues(value={@ExampleValues.Example(value="/some_key == null", description="Only runs the convert_type processor on the Event if the existing key some_key is null or does not exist."), @ExampleValues.Example(value="/some_key typeof integer", description="Only runs the convert_type processor on the Event if the key some_key is an integer.")})
    private String convertWhen;
    @JsonProperty(value="iterate_on")
    @JsonPropertyDescription(value="Specifies the key of a list of map objects to iterate over and convert types.")
    private String iterateOn;

    public CoerceStringsConfig getCoerceStrings() {
        return this.coerceStrings;
    }

    public String getKey() {
        return this.key;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public TargetType getType() {
        return this.type;
    }

    public int getScale() {
        return this.scale;
    }

    public String getConvertWhen() {
        return this.convertWhen;
    }

    public Optional<List<String>> getNullValues() {
        return Optional.ofNullable(this.nullValues);
    }

    public List<String> getTagsOnFailure() {
        return this.tagsOnFailure;
    }

    public String getIterateOn() {
        return this.iterateOn;
    }

    public static class CoerceStringsConfig {
        @JsonProperty(value="time_formats")
        List<String> coerceStringTimeFormats = DEFAULT_TIME_STRING_FORMATS;

        public List<String> getCoerceStringTimeFormats() {
            return this.coerceStringTimeFormats;
        }
    }
}

