/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.stream.Stream;
import org.opensearch.dataprepper.model.annotations.AlsoRequired;
import org.opensearch.dataprepper.model.annotations.ConditionalRequired;
import org.opensearch.dataprepper.model.annotations.ExampleValues;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;

@ConditionalRequired(value={@ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="key", value="null")}, thenExpect={@ConditionalRequired.SchemaProperty(field="metadata_key")}), @ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="metadata_key", value="null")}, thenExpect={@ConditionalRequired.SchemaProperty(field="key")}), @ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="format", value="null"), @ConditionalRequired.SchemaProperty(field="value", value="null")}, thenExpect={@ConditionalRequired.SchemaProperty(field="value_expression")}), @ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="format", value="null"), @ConditionalRequired.SchemaProperty(field="value_expression", value="null")}, thenExpect={@ConditionalRequired.SchemaProperty(field="value")}), @ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="value", value="null"), @ConditionalRequired.SchemaProperty(field="value_expression", value="null")}, thenExpect={@ConditionalRequired.SchemaProperty(field="format")})})
@JsonPropertyOrder
@JsonClassDescription(value="The <code>add_entries</code> processor adds entries to an event.")
public class AddEntryProcessorConfig {
    static final String VALUE_EXPRESSION_KEY = "value_expression";
    static final String METADATA_KEY_KEY = "metadata_key";
    static final String APPEND_IF_KEY_EXISTS_KEY = "append_if_key_exists";
    static final String OVERWRITE_IF_KEY_EXISTS_KEY = "overwrite_if_key_exists";
    @NotEmpty
    @NotNull
    @Valid
    @JsonPropertyDescription(value="A list of entries to add to the event.")
    private List<Entry> entries;

    public List<Entry> getEntries() {
        return this.entries;
    }

    @JsonPropertyOrder
    public static class Entry {
        @JsonProperty(value="iterate_on")
        @JsonPropertyDescription(value="Specifies the key of the list of object to iterate over and add entry into.")
        private String iterateOn;
        @JsonPropertyDescription(value="Specifies the condition for when to add the key to each element of a list when using iterate_on.")
        @JsonProperty(value="add_to_element_when")
        private String addToElementWhen;
        @JsonPropertyDescription(value="The key of the new entry to be added. Some examples of keys include <code>my_key</code>, <code>myKey</code>, and <code>object/sub_Key</code>. The key can also be a format expression, for example, <code>${/key1}</code> to use the value of field <code>key1</code> as the key. Exactly one of <code>key</code> or <code>metadata_key</code> is required.")
        @AlsoRequired(values={@AlsoRequired.Required(name="metadata_key", allowedValues={"null"})})
        @ExampleValues(value={@ExampleValues.Example(value="my_key", description="Adds 'my_key' to the Event"), @ExampleValues.Example(value="${/key_one}-${/key_two}", description="Evaluates existing Event keys key_one and key_two and adds the result to the Event"), @ExampleValues.Example(value="/nested/key", description="Adds a nested key of { \"nested\": { \"key\": \"some_value\" }")})
        private String key;
        @JsonProperty(value="metadata_key")
        @JsonPropertyDescription(value="The key for the new metadata attribute. The argument must be a literal string key and not a JSON Pointer. Adds an attribute to the Events that will not be sent to the sinks, but can be used for condition expressions and routing with the getMetadata function. Exactly one of <code>key</code> or <code>metadata_key</code> is required.")
        @AlsoRequired(values={@AlsoRequired.Required(name="key", allowedValues={"null"})})
        @ExampleValues(value={@ExampleValues.Example(value="some_metadata", description="The Event will contain a metadata key called 'some_metadata' that can be used in expressions with sending the key to the sinks.")})
        private String metadataKey;
        @JsonPropertyDescription(value="The value of the new entry to be added, which can be used with any of the following data types: strings, Booleans, numbers, null, nested objects, and arrays.")
        @AlsoRequired(values={@AlsoRequired.Required(name="format", allowedValues={"null"}), @AlsoRequired.Required(name="value_expression", allowedValues={"null"})})
        @ExampleValues(value={@ExampleValues.Example(value="my_string_value", description="Adds a value of 'my_string_value' to the key or metadata_key"), @ExampleValues.Example(value="false", description="Adds a value of false to the key or metadata_key"), @ExampleValues.Example(value="10", description="Adds a value of 10 to the key or metadata_key"), @ExampleValues.Example(value="[ \"element_one\", \"element_two\" ]", description="Adds an array value with two elements to the key or metadata_key")})
        private Object value;
        @JsonPropertyDescription(value="A format string to use as the value of the new entry, for example, <code>${key1}-${key2}</code>, where <code>key1</code> and <code>key2</code> are existing keys in the event. Required if neither <code>value</code> nor <code>value_expression</code> is specified.")
        @AlsoRequired(values={@AlsoRequired.Required(name="value", allowedValues={"null"}), @AlsoRequired.Required(name="value_expression", allowedValues={"null"})})
        @ExampleValues(value={@ExampleValues.Example(value="${/key_one}-${/key_two}", description="Adds a value as a combination of the existing key_one and key_two values to the key or metadata_key")})
        private String format;
        @JsonProperty(value="value_expression")
        @JsonPropertyDescription(value="An expression string to use as the value of the new entry. For example, <code>/key</code> is an existing key in the event with a type of either a number, a string, or a Boolean. Expressions can also contain functions returning number/string/integer. For example, <code>length(/key)</code> will return the length of the key in the event when the key is a string. For more information about keys, see <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">Expression syntax</a>.")
        @AlsoRequired(values={@AlsoRequired.Required(name="value", allowedValues={"null"}), @AlsoRequired.Required(name="format", allowedValues={"null"})})
        @ExampleValues(value={@ExampleValues.Example(value="length(/my_key)", description="Adds an integer value based on the length of the existing key 'my_key' to the new key or metadata_key"), @ExampleValues.Example(value="/my_key", description="Adds a value based on the existing value of my_key to the new key or metadata_key")})
        private String valueExpression;
        @JsonProperty(value="overwrite_if_key_exists")
        @JsonPropertyDescription(value="When set to <code>true</code>, the existing value is overwritten if <code>key</code> already exists in the event. Only one of <code>overwrite_if_key_exists</code> or <code>append_if_key_exists</code> can be <code>true</code>. The default value is <code>false</code>.")
        @AlsoRequired(values={@AlsoRequired.Required(name="append_if_key_exists", allowedValues={"false"})})
        private boolean overwriteIfKeyExists = false;
        @JsonProperty(value="append_if_key_exists")
        @JsonPropertyDescription(value="When set to <code>true</code>, the existing value will be appended if a <code>key</code> already exists in the event. An array will be created if the existing value is not an array. Default is <code>false</code>.")
        @AlsoRequired(values={@AlsoRequired.Required(name="overwrite_if_key_exists", allowedValues={"false"})})
        private boolean appendIfKeyExists = false;
        @JsonProperty(value="flatten_key")
        @JsonPropertyDescription(value="When true and used with iterate_on, treats the key as a plain string. When false and used with iterate_on, treats the key as a json pointer. Has no effect when not used with iterate_on.")
        @AlsoRequired(values={@AlsoRequired.Required(name="iterate_on")})
        private boolean flattenKey = true;
        @JsonProperty(value="add_when")
        @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a>, such as <code>/some-key == \"test\"</code>, that will be evaluated to determine whether the processor will be run on the event.")
        @ExampleValues(value={@ExampleValues.Example(value="/some_key == null", description="Only runs the add_entries processor if the key some_key is null or does not exist.")})
        private String addWhen;

        public String getIterateOn() {
            return this.iterateOn;
        }

        public String getAddToElementWhen() {
            return this.addToElementWhen;
        }

        public String getKey() {
            return this.key;
        }

        public String getMetadataKey() {
            return this.metadataKey;
        }

        public Object getValue() {
            return this.value;
        }

        public String getFormat() {
            return this.format;
        }

        public String getValueExpression() {
            return this.valueExpression;
        }

        public boolean getOverwriteIfKeyExists() {
            return this.overwriteIfKeyExists;
        }

        public boolean getAppendIfKeyExists() {
            return this.appendIfKeyExists;
        }

        public boolean getFlattenKey() {
            return this.flattenKey;
        }

        public String getAddWhen() {
            return this.addWhen;
        }

        @AssertTrue(message="Either value or format or expression must be specified, and only one of them can be specified")
        public @AssertTrue(message="Either value or format or expression must be specified, and only one of them can be specified") boolean hasValueOrFormatOrExpression() {
            return Stream.of(this.value, this.format, this.valueExpression).filter(n -> n != null).count() == 1L;
        }

        @AssertTrue(message="overwrite_if_key_exists and append_if_key_exists can not be set to true at the same time.")
        @AssertTrue(message="overwrite_if_key_exists and append_if_key_exists can not be set to true at the same time.") boolean overwriteAndAppendNotBothSet() {
            return !this.overwriteIfKeyExists || !this.appendIfKeyExists;
        }

        @AssertTrue(message="flatten_key=false must be used with iterate_on.")
        @AssertTrue(message="flatten_key=false must be used with iterate_on.") boolean flattenKeyFalseIsUsedWithIterateOn() {
            return !this.flattenKey && this.iterateOn != null || this.flattenKey;
        }

        public Entry(String key, String metadataKey, Object value, String format, String valueExpression, boolean overwriteIfKeyExists, boolean appendIfKeyExists, String addWhen, String iterateOn, boolean flattenKey, String addToElementWhen) {
            if (key != null && metadataKey != null) {
                throw new IllegalArgumentException("Only one of the two - key and metadatakey - should be specified");
            }
            if (key == null && metadataKey == null) {
                throw new IllegalArgumentException("At least one of the two - key and metadatakey - must be specified");
            }
            if (metadataKey != null && iterateOn != null) {
                throw new IllegalArgumentException("iterate_on cannot be applied to metadata");
            }
            if (iterateOn == null && addToElementWhen != null) {
                throw new InvalidPluginConfigurationException("add_to_element_when only applies when iterate_on is configured.");
            }
            this.key = key;
            this.metadataKey = metadataKey;
            this.value = value;
            this.format = format;
            this.valueExpression = valueExpression;
            this.overwriteIfKeyExists = overwriteIfKeyExists;
            this.appendIfKeyExists = appendIfKeyExists;
            this.addWhen = addWhen;
            this.iterateOn = iterateOn;
            this.flattenKey = flattenKey;
            this.addToElementWhen = addToElementWhen;
        }

        public Entry(String key, String metadataKey, Object value, String format, String valueExpression, boolean overwriteIfKeyExists, boolean appendIfKeyExists, String addWhen, String iterateOn, String addToElementWhen) {
            if (key != null && metadataKey != null) {
                throw new IllegalArgumentException("Only one of the two - key and metadatakey - should be specified");
            }
            if (key == null && metadataKey == null) {
                throw new IllegalArgumentException("At least one of the two - key and metadatakey - must be specified");
            }
            if (metadataKey != null && iterateOn != null) {
                throw new IllegalArgumentException("iterate_on cannot be applied to metadata");
            }
            if (iterateOn == null && addToElementWhen != null) {
                throw new InvalidPluginConfigurationException("add_to_element_when only applies when iterate_on is configured.");
            }
            this.key = key;
            this.metadataKey = metadataKey;
            this.value = value;
            this.format = format;
            this.valueExpression = valueExpression;
            this.overwriteIfKeyExists = overwriteIfKeyExists;
            this.appendIfKeyExists = appendIfKeyExists;
            this.addWhen = addWhen;
            this.iterateOn = iterateOn;
            this.flattenKey = true;
            this.addToElementWhen = addToElementWhen;
        }

        public Entry() {
        }
    }
}

