/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyFactory;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.event.exceptions.EventKeyNotFoundException;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.mutateevent.AddEntryProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="add_entries", pluginType=Processor.class, pluginConfigurationType=AddEntryProcessorConfig.class)
public class AddEntryProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddEntryProcessor.class);
    private static final String ERROR_LOG_MESSAGE = "Error adding entry to record [{}] with iterate_on [{}], add_to_element_when [{}], key [{}], metadataKey [{}], value_expression [{}] format [{}], value [{}]";
    private final List<AddEntryProcessorConfig.Entry> entries;
    private final List<EntryProperties> entryProperties;
    private final List<KeyInfo> preprocessedKeys;
    private final ExpressionEvaluator expressionEvaluator;
    private final EventKeyFactory eventKeyFactory;
    private static final Class<List<Map<String, Object>>> ITERATE_LIST_CLASS = List.class;

    @DataPrepperPluginConstructor
    public AddEntryProcessor(PluginMetrics pluginMetrics, AddEntryProcessorConfig config, ExpressionEvaluator expressionEvaluator, EventKeyFactory eventKeyFactory) {
        super(pluginMetrics);
        this.entries = config.getEntries();
        this.expressionEvaluator = expressionEvaluator;
        this.eventKeyFactory = eventKeyFactory;
        this.preprocessedKeys = new ArrayList<KeyInfo>(this.entries.size());
        this.entryProperties = new ArrayList<EntryProperties>(this.entries.size());
        config.getEntries().forEach(entry -> {
            if (entry.getAddWhen() != null && !expressionEvaluator.isValidExpressionStatement(entry.getAddWhen()).booleanValue()) {
                throw new InvalidPluginConfigurationException(String.format("add_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", entry.getAddWhen()));
            }
            if (entry.getAddToElementWhen() != null && !expressionEvaluator.isValidExpressionStatement(entry.getAddToElementWhen()).booleanValue()) {
                throw new InvalidPluginConfigurationException(String.format("add_to_element_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", entry.getAddWhen()));
            }
            this.preprocessedKeys.add(new KeyInfo(entry.getKey(), eventKeyFactory, entry.getAddWhen(), entry.getFormat()));
            this.entryProperties.add(new EntryProperties((AddEntryProcessorConfig.Entry)entry, expressionEvaluator));
        });
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            try {
                for (int i = 0; i < this.entries.size(); ++i) {
                    AddEntryProcessorConfig.Entry entry = this.entries.get(i);
                    KeyInfo keyInfo = this.preprocessedKeys.get(i);
                    EntryProperties props = this.entryProperties.get(i);
                    if (Objects.nonNull(props.addWhen) && !this.expressionEvaluator.evaluateConditional(props.addWhen, recordEvent).booleanValue()) continue;
                    try {
                        EventKey key = null;
                        if (keyInfo.keyStr != null) {
                            try {
                                key = keyInfo.isDynamic ? this.eventKeyFactory.createEventKey(recordEvent.formatString(keyInfo.keyStr, this.expressionEvaluator)) : keyInfo.staticKey;
                            }
                            catch (Exception e) {
                                LOG.debug("Failed to resolve or create key {} for event {}", new Object[]{keyInfo.keyStr, recordEvent, e});
                            }
                        }
                        String metadataKey = entry.getMetadataKey();
                        String iterateOn = entry.getIterateOn();
                        boolean flattenKey = entry.getFlattenKey();
                        if (Objects.isNull(iterateOn)) {
                            this.handleWithoutIterateOn(entry, recordEvent, key, metadataKey, props);
                            continue;
                        }
                        if (Objects.isNull(key) || key.getKey() == null) continue;
                        this.handleWithIterateOn(entry, recordEvent, iterateOn, flattenKey, key, props);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage(ERROR_LOG_MESSAGE).addArgument((Object)recordEvent).addArgument((Object)entry.getIterateOn()).addArgument((Object)entry.getAddToElementWhen()).addArgument((Object)entry.getKey()).addArgument((Object)entry.getMetadataKey()).addArgument((Object)entry.getValueExpression()).addArgument((Object)entry.getFormat()).addArgument(entry.getValue()).log();
                    }
                }
            }
            catch (Exception e) {
                LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("There was an exception while processing Event [{}]").addArgument((Object)recordEvent).setCause((Throwable)e).log();
            }
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }

    private void handleWithoutIterateOn(AddEntryProcessorConfig.Entry entry, Event recordEvent, EventKey key, String metadataKey, EntryProperties props) {
        Object value = this.retrieveValue(entry, recordEvent);
        if (!Objects.isNull(key)) {
            boolean keyExists = recordEvent.containsKey(key);
            if (!keyExists || props.overwriteIfExists) {
                recordEvent.put(key, value);
            } else if (keyExists && props.appendIfExists) {
                this.mergeValueToEvent(recordEvent, key, value);
            }
        } else {
            Map attributes = recordEvent.getMetadata().getAttributes();
            if (!attributes.containsKey(metadataKey) || props.overwriteIfExists) {
                recordEvent.getMetadata().setAttribute(metadataKey, value);
            } else if (attributes.containsKey(metadataKey) && props.appendIfExists) {
                this.mergeValueToEventMetadata(recordEvent, metadataKey, value);
            }
        }
    }

    private void handleWithIterateOn(AddEntryProcessorConfig.Entry entry, Event recordEvent, String iterateOn, boolean flattenKey, EventKey key, EntryProperties props) {
        List iterateOnList = (List)recordEvent.get(iterateOn, ITERATE_LIST_CLASS);
        if (iterateOnList != null && !iterateOnList.isEmpty()) {
            boolean shouldProcessAll;
            JacksonEvent.Builder contextBuilder = JacksonEvent.builder().withEventMetadata(recordEvent.getMetadata());
            boolean bl = shouldProcessAll = props.addToElementWhen == null || this.expressionEvaluator.evaluateConditional(props.addToElementWhen, recordEvent) != false;
            if (shouldProcessAll) {
                for (int i = 0; i < iterateOnList.size(); ++i) {
                    Map item = (Map)iterateOnList.get(i);
                    iterateOnList.set(i, this.processIterateOnItem(entry, contextBuilder, item, flattenKey, key, props));
                }
            } else {
                for (int i = 0; i < iterateOnList.size(); ++i) {
                    Map item = (Map)iterateOnList.get(i);
                    if (!this.expressionEvaluator.evaluateConditional(props.addToElementWhen, recordEvent).booleanValue()) continue;
                    iterateOnList.set(i, this.processIterateOnItem(entry, contextBuilder, item, flattenKey, key, props));
                }
            }
            recordEvent.put(iterateOn, (Object)iterateOnList);
        }
    }

    private Map<String, Object> processIterateOnItem(AddEntryProcessorConfig.Entry entry, JacksonEvent.Builder contextBuilder, Map<String, Object> item, boolean flattenKey, EventKey key, EntryProperties props) {
        JacksonEvent context = contextBuilder.withData(item).build();
        Object value = this.retrieveValue(entry, (Event)context);
        String keyStr = key.getKey();
        if (!item.containsKey(keyStr) || props.overwriteIfExists) {
            if (flattenKey) {
                item.put(keyStr, value);
            } else {
                context.put(key, value);
            }
        } else if (item.containsKey(keyStr) && props.appendIfExists) {
            if (flattenKey) {
                this.mergeValueToMap(item, keyStr, value);
            } else {
                this.mergeValueToEvent((Event)context, key, value);
            }
        }
        if (flattenKey) {
            return item;
        }
        return context.toMap();
    }

    private Object retrieveValue(AddEntryProcessorConfig.Entry entry, Event context) {
        Object value;
        block11: {
            int entryIndex = this.entries.indexOf(entry);
            EntryProperties props = this.entryProperties.get(entryIndex);
            KeyInfo keyInfo = this.preprocessedKeys.get(entryIndex);
            if (!Objects.isNull(entry.getValueExpression())) {
                value = props.staticExpressionValue != null ? props.staticExpressionValue : this.expressionEvaluator.evaluate(entry.getValueExpression(), context);
            } else if (!Objects.isNull(entry.getFormat())) {
                try {
                    if (keyInfo.formatParts != null) {
                        StringBuilder result = new StringBuilder();
                        for (String part : keyInfo.formatParts) {
                            if (part.startsWith("${")) {
                                String key = part.substring(2, part.length() - 1);
                                try {
                                    Object partValue = context.get(key, Object.class);
                                    if (partValue == null) continue;
                                    result.append(partValue);
                                }
                                catch (EventKeyNotFoundException eventKeyNotFoundException) {}
                                continue;
                            }
                            result.append(part);
                        }
                        value = result.toString();
                        break block11;
                    }
                    value = context.formatString(entry.getFormat());
                }
                catch (EventKeyNotFoundException e) {
                    value = null;
                }
            } else {
                value = entry.getValue();
            }
        }
        return value;
    }

    private void mergeValueToEvent(Event recordEvent, EventKey key, Object value) {
        this.mergeValue(value, () -> recordEvent.get(key, Object.class), newValue -> recordEvent.put(key, newValue));
    }

    private void mergeValueToEventMetadata(Event recordEvent, String key, Object value) {
        this.mergeValue(value, () -> recordEvent.getMetadata().getAttribute(key), newValue -> recordEvent.getMetadata().setAttribute(key, newValue));
    }

    private void mergeValueToMap(Map<String, Object> item, String key, Object value) {
        this.mergeValue(value, () -> item.get(key), newValue -> item.put(key, newValue));
    }

    private void mergeValue(Object value, Supplier<Object> getter, Consumer<Object> setter) {
        Object currentValue = getter.get();
        ArrayList<Object> mergedValue = new ArrayList<Object>();
        if (currentValue instanceof List) {
            mergedValue.addAll((List)currentValue);
        } else {
            mergedValue.add(currentValue);
        }
        mergedValue.add(value);
        setter.accept(mergedValue);
    }

    private static class KeyInfo {
        private final String keyStr;
        private final boolean isDynamic;
        private final EventKey staticKey;
        private final boolean addWhenEvaluated;
        private final String[] formatParts;

        KeyInfo(String keyStr, EventKeyFactory factory, String addWhen, String format) {
            this.keyStr = keyStr;
            this.isDynamic = keyStr != null && (keyStr.contains("%{") || keyStr.contains("${"));
            this.staticKey = !this.isDynamic && keyStr != null ? factory.createEventKey(keyStr) : null;
            this.addWhenEvaluated = addWhen == null;
            this.formatParts = format != null ? this.parseFormat(format) : null;
        }

        private String[] parseFormat(String format) {
            if (!this.isValidFormat(format)) {
                return null;
            }
            ArrayList<String> parts = new ArrayList<String>();
            StringBuilder current = new StringBuilder();
            int i = 0;
            while (i < format.length()) {
                if (format.charAt(i) == '$' && i + 1 < format.length() && format.charAt(i + 1) == '{') {
                    int end;
                    if (current.length() > 0) {
                        parts.add(current.toString());
                        current = new StringBuilder();
                    }
                    if ((end = format.indexOf(125, i)) == -1) break;
                    parts.add(format.substring(i, end + 1));
                    i = end + 1;
                    continue;
                }
                current.append(format.charAt(i));
                ++i;
            }
            if (current.length() > 0) {
                parts.add(current.toString());
            }
            return parts.toArray(new String[0]);
        }

        private boolean isValidFormat(String format) {
            if (format == null) {
                return false;
            }
            int count = 0;
            for (int i = 0; i < format.length(); ++i) {
                if (format.charAt(i) != '$' || i + 1 >= format.length() || format.charAt(i + 1) != '{') continue;
                ++count;
                int end = format.indexOf(125, i);
                if (end == -1) {
                    return false;
                }
                i = end;
            }
            return count > 0;
        }
    }

    private static class EntryProperties {
        final boolean overwriteIfExists;
        final boolean appendIfExists;
        final String addWhen;
        final String addToElementWhen;
        final Object staticExpressionValue;

        EntryProperties(AddEntryProcessorConfig.Entry entry, ExpressionEvaluator evaluator) {
            this.overwriteIfExists = entry.getOverwriteIfKeyExists();
            this.appendIfExists = entry.getAppendIfKeyExists();
            this.addWhen = entry.getAddWhen();
            this.addToElementWhen = entry.getAddToElementWhen();
            String valueExpr = entry.getValueExpression();
            this.staticExpressionValue = valueExpr != null && !this.containsEventReference(valueExpr) ? evaluator.evaluate(valueExpr, null) : null;
        }

        private boolean containsEventReference(String expression) {
            return expression.contains("/") || expression.contains("getMetadata");
        }
    }
}

