/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sourcecoordinator.dynamodb;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;

class DdbClientCustomRetryCondition
implements RetryCondition {
    private static final Logger LOG = LoggerFactory.getLogger(DdbClientCustomRetryCondition.class);
    private static final int DEFAULT_RETRIES = 10;
    private final RetryCondition defaultRetryCondition = RetryCondition.defaultRetryCondition();

    DdbClientCustomRetryCondition() {
    }

    public boolean shouldRetry(RetryPolicyContext context) {
        if (context.exception() instanceof ProvisionedThroughputExceededException) {
            LOG.warn("Received throttling from DynamoDb after {} attempts, retrying: {}", (Object)context.retriesAttempted(), (Object)context.exception().getMessage());
            return true;
        }
        if (context.retriesAttempted() >= 10) {
            return false;
        }
        return this.defaultRetryCondition.shouldRetry(context);
    }
}

