/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.otel.codec;

import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceRequest;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.trace.v1.ResourceSpans;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.DecoderException;
import org.opensearch.dataprepper.model.log.OpenTelemetryLog;
import org.opensearch.dataprepper.model.metric.Metric;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.trace.Span;

public interface OTelProtoCodec {
    public static final int DEFAULT_EXPONENTIAL_HISTOGRAM_MAX_ALLOWED_SCALE = 10;

    public static interface OTelProtoEncoder {
        public ResourceSpans convertToResourceSpans(Span var1) throws UnsupportedEncodingException, DecoderException;
    }

    public static interface OTelProtoDecoder {
        public List<Span> parseExportTraceServiceRequest(ExportTraceServiceRequest var1, Instant var2);

        public Map<String, ExportTraceServiceRequest> splitExportTraceServiceRequestByTraceId(ExportTraceServiceRequest var1);

        public List<OpenTelemetryLog> parseExportLogsServiceRequest(ExportLogsServiceRequest var1, Instant var2);

        default public Collection<Record<? extends Metric>> parseExportMetricsServiceRequest(ExportMetricsServiceRequest request, Instant timeReceived) {
            AtomicInteger droppedCounter = new AtomicInteger(0);
            return this.parseExportMetricsServiceRequest(request, droppedCounter, 10, timeReceived, true, true, true);
        }

        public Collection<Record<? extends Metric>> parseExportMetricsServiceRequest(ExportMetricsServiceRequest var1, AtomicInteger var2, Integer var3, Instant var4, boolean var5, boolean var6, boolean var7);
    }
}

