/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.otel.codec;

import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.opensearch.dataprepper.model.codec.ByteDecoder;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.metric.Metric;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.otel.codec.OTelOutputFormat;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoOpensearchCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoStandardCodec;

public class OTelMetricDecoder
implements ByteDecoder {
    private final OTelProtoCodec.OTelProtoDecoder otelProtoDecoder;

    public OTelMetricDecoder(OTelOutputFormat otelOutputFormat) {
        this.otelProtoDecoder = otelOutputFormat == OTelOutputFormat.OPENSEARCH ? new OTelProtoOpensearchCodec.OTelProtoDecoder() : new OTelProtoStandardCodec.OTelProtoDecoder();
    }

    public void parse(InputStream inputStream, Instant timeReceivedMs, Consumer<Record<Event>> eventConsumer) throws IOException {
        ExportMetricsServiceRequest request = ExportMetricsServiceRequest.parseFrom((InputStream)inputStream);
        AtomicInteger droppedCounter = new AtomicInteger(0);
        Collection<Record<? extends Metric>> records = this.otelProtoDecoder.parseExportMetricsServiceRequest(request, droppedCounter, 10, timeReceivedMs, true, true, false);
        for (Record<? extends Metric> record : records) {
            eventConsumer.accept(record);
        }
    }
}

