/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.DashboardViewerPrincipalsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenSearchResourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenSearchResourceConfig> {
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(OpenSearchResourceConfig.getter(OpenSearchResourceConfig::kmsKeyArn)).setter(OpenSearchResourceConfig.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceRoleArn").getter(OpenSearchResourceConfig.getter(OpenSearchResourceConfig::dataSourceRoleArn)).setter(OpenSearchResourceConfig.setter(Builder::dataSourceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceRoleArn").build()}).build();
    private static final SdkField<List<String>> DASHBOARD_VIEWER_PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dashboardViewerPrincipals").getter(OpenSearchResourceConfig.getter(OpenSearchResourceConfig::dashboardViewerPrincipals)).setter(OpenSearchResourceConfig.setter(Builder::dashboardViewerPrincipals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardViewerPrincipals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationArn").getter(OpenSearchResourceConfig.getter(OpenSearchResourceConfig::applicationArn)).setter(OpenSearchResourceConfig.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()}).build();
    private static final SdkField<Integer> RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retentionDays").getter(OpenSearchResourceConfig.getter(OpenSearchResourceConfig::retentionDays)).setter(OpenSearchResourceConfig.setter(Builder::retentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ARN_FIELD, DATA_SOURCE_ROLE_ARN_FIELD, DASHBOARD_VIEWER_PRINCIPALS_FIELD, APPLICATION_ARN_FIELD, RETENTION_DAYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OpenSearchResourceConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String kmsKeyArn;
    private final String dataSourceRoleArn;
    private final List<String> dashboardViewerPrincipals;
    private final String applicationArn;
    private final Integer retentionDays;

    private OpenSearchResourceConfig(BuilderImpl builder) {
        this.kmsKeyArn = builder.kmsKeyArn;
        this.dataSourceRoleArn = builder.dataSourceRoleArn;
        this.dashboardViewerPrincipals = builder.dashboardViewerPrincipals;
        this.applicationArn = builder.applicationArn;
        this.retentionDays = builder.retentionDays;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final String dataSourceRoleArn() {
        return this.dataSourceRoleArn;
    }

    public final boolean hasDashboardViewerPrincipals() {
        return this.dashboardViewerPrincipals != null && !(this.dashboardViewerPrincipals instanceof SdkAutoConstructList);
    }

    public final List<String> dashboardViewerPrincipals() {
        return this.dashboardViewerPrincipals;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final Integer retentionDays() {
        return this.retentionDays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDashboardViewerPrincipals() ? this.dashboardViewerPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionDays());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenSearchResourceConfig)) {
            return false;
        }
        OpenSearchResourceConfig other = (OpenSearchResourceConfig)obj;
        return Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.dataSourceRoleArn(), other.dataSourceRoleArn()) && this.hasDashboardViewerPrincipals() == other.hasDashboardViewerPrincipals() && Objects.equals(this.dashboardViewerPrincipals(), other.dashboardViewerPrincipals()) && Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.retentionDays(), other.retentionDays());
    }

    public final String toString() {
        return ToString.builder((String)"OpenSearchResourceConfig").add("KmsKeyArn", (Object)this.kmsKeyArn()).add("DataSourceRoleArn", (Object)this.dataSourceRoleArn()).add("DashboardViewerPrincipals", this.hasDashboardViewerPrincipals() ? this.dashboardViewerPrincipals() : null).add("ApplicationArn", (Object)this.applicationArn()).add("RetentionDays", (Object)this.retentionDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "dataSourceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataSourceRoleArn()));
            }
            case "dashboardViewerPrincipals": {
                return Optional.ofNullable(clazz.cast(this.dashboardViewerPrincipals()));
            }
            case "applicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "retentionDays": {
                return Optional.ofNullable(clazz.cast(this.retentionDays()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("dataSourceRoleArn", DATA_SOURCE_ROLE_ARN_FIELD);
        map.put("dashboardViewerPrincipals", DASHBOARD_VIEWER_PRINCIPALS_FIELD);
        map.put("applicationArn", APPLICATION_ARN_FIELD);
        map.put("retentionDays", RETENTION_DAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenSearchResourceConfig, T> g) {
        return obj -> g.apply((OpenSearchResourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyArn;
        private String dataSourceRoleArn;
        private List<String> dashboardViewerPrincipals = DefaultSdkAutoConstructList.getInstance();
        private String applicationArn;
        private Integer retentionDays;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenSearchResourceConfig model) {
            this.kmsKeyArn(model.kmsKeyArn);
            this.dataSourceRoleArn(model.dataSourceRoleArn);
            this.dashboardViewerPrincipals(model.dashboardViewerPrincipals);
            this.applicationArn(model.applicationArn);
            this.retentionDays(model.retentionDays);
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getDataSourceRoleArn() {
            return this.dataSourceRoleArn;
        }

        public final void setDataSourceRoleArn(String dataSourceRoleArn) {
            this.dataSourceRoleArn = dataSourceRoleArn;
        }

        @Override
        public final Builder dataSourceRoleArn(String dataSourceRoleArn) {
            this.dataSourceRoleArn = dataSourceRoleArn;
            return this;
        }

        public final Collection<String> getDashboardViewerPrincipals() {
            if (this.dashboardViewerPrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dashboardViewerPrincipals;
        }

        public final void setDashboardViewerPrincipals(Collection<String> dashboardViewerPrincipals) {
            this.dashboardViewerPrincipals = DashboardViewerPrincipalsCopier.copy(dashboardViewerPrincipals);
        }

        @Override
        public final Builder dashboardViewerPrincipals(Collection<String> dashboardViewerPrincipals) {
            this.dashboardViewerPrincipals = DashboardViewerPrincipalsCopier.copy(dashboardViewerPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardViewerPrincipals(String ... dashboardViewerPrincipals) {
            this.dashboardViewerPrincipals(Arrays.asList(dashboardViewerPrincipals));
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final Integer getRetentionDays() {
            return this.retentionDays;
        }

        public final void setRetentionDays(Integer retentionDays) {
            this.retentionDays = retentionDays;
        }

        @Override
        public final Builder retentionDays(Integer retentionDays) {
            this.retentionDays = retentionDays;
            return this;
        }

        public OpenSearchResourceConfig build() {
            return new OpenSearchResourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenSearchResourceConfig> {
        public Builder kmsKeyArn(String var1);

        public Builder dataSourceRoleArn(String var1);

        public Builder dashboardViewerPrincipals(Collection<String> var1);

        public Builder dashboardViewerPrincipals(String ... var1);

        public Builder applicationArn(String var1);

        public Builder retentionDays(Integer var1);
    }
}

