/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.IntegrationSummariesCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.IntegrationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIntegrationsResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, ListIntegrationsResponse> {
    private static final SdkField<List<IntegrationSummary>> INTEGRATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("integrationSummaries").getter(ListIntegrationsResponse.getter(ListIntegrationsResponse::integrationSummaries)).setter(ListIntegrationsResponse.setter(Builder::integrationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IntegrationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIntegrationsResponse.memberNameToFieldInitializer();
    private final List<IntegrationSummary> integrationSummaries;

    private ListIntegrationsResponse(BuilderImpl builder) {
        super(builder);
        this.integrationSummaries = builder.integrationSummaries;
    }

    public final boolean hasIntegrationSummaries() {
        return this.integrationSummaries != null && !(this.integrationSummaries instanceof SdkAutoConstructList);
    }

    public final List<IntegrationSummary> integrationSummaries() {
        return this.integrationSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegrationSummaries() ? this.integrationSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIntegrationsResponse)) {
            return false;
        }
        ListIntegrationsResponse other = (ListIntegrationsResponse)((Object)obj);
        return this.hasIntegrationSummaries() == other.hasIntegrationSummaries() && Objects.equals(this.integrationSummaries(), other.integrationSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListIntegrationsResponse").add("IntegrationSummaries", this.hasIntegrationSummaries() ? this.integrationSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "integrationSummaries": {
                return Optional.ofNullable(clazz.cast(this.integrationSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<IntegrationSummary>>> map = new HashMap<String, SdkField<List<IntegrationSummary>>>();
        map.put("integrationSummaries", INTEGRATION_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIntegrationsResponse, T> g) {
        return obj -> g.apply((ListIntegrationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<IntegrationSummary> integrationSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListIntegrationsResponse model) {
            super(model);
            this.integrationSummaries(model.integrationSummaries);
        }

        public final List<IntegrationSummary.Builder> getIntegrationSummaries() {
            List<IntegrationSummary.Builder> result = IntegrationSummariesCopier.copyToBuilder(this.integrationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegrationSummaries(Collection<IntegrationSummary.BuilderImpl> integrationSummaries) {
            this.integrationSummaries = IntegrationSummariesCopier.copyFromBuilder(integrationSummaries);
        }

        @Override
        public final Builder integrationSummaries(Collection<IntegrationSummary> integrationSummaries) {
            this.integrationSummaries = IntegrationSummariesCopier.copy(integrationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationSummaries(IntegrationSummary ... integrationSummaries) {
            this.integrationSummaries(Arrays.asList(integrationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationSummaries(Consumer<IntegrationSummary.Builder> ... integrationSummaries) {
            this.integrationSummaries(Stream.of(integrationSummaries).map(c -> (IntegrationSummary)((IntegrationSummary.Builder)IntegrationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListIntegrationsResponse build() {
            return new ListIntegrationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIntegrationsResponse> {
        public Builder integrationSummaries(Collection<IntegrationSummary> var1);

        public Builder integrationSummaries(IntegrationSummary ... var1);

        public Builder integrationSummaries(Consumer<IntegrationSummary.Builder> ... var1);
    }
}

