/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.Processor;
import software.amazon.awssdk.services.cloudwatchlogs.model.ProcessorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTransformerResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, GetTransformerResponse> {
    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupIdentifier").getter(GetTransformerResponse.getter(GetTransformerResponse::logGroupIdentifier)).setter(GetTransformerResponse.setter(Builder::logGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("creationTime").getter(GetTransformerResponse.getter(GetTransformerResponse::creationTime)).setter(GetTransformerResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastModifiedTime").getter(GetTransformerResponse.getter(GetTransformerResponse::lastModifiedTime)).setter(GetTransformerResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()}).build();
    private static final SdkField<List<Processor>> TRANSFORMER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("transformerConfig").getter(GetTransformerResponse.getter(GetTransformerResponse::transformerConfig)).setter(GetTransformerResponse.setter(Builder::transformerConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Processor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_IDENTIFIER_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, TRANSFORMER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTransformerResponse.memberNameToFieldInitializer();
    private final String logGroupIdentifier;
    private final Long creationTime;
    private final Long lastModifiedTime;
    private final List<Processor> transformerConfig;

    private GetTransformerResponse(BuilderImpl builder) {
        super(builder);
        this.logGroupIdentifier = builder.logGroupIdentifier;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.transformerConfig = builder.transformerConfig;
    }

    public final String logGroupIdentifier() {
        return this.logGroupIdentifier;
    }

    public final Long creationTime() {
        return this.creationTime;
    }

    public final Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final boolean hasTransformerConfig() {
        return this.transformerConfig != null && !(this.transformerConfig instanceof SdkAutoConstructList);
    }

    public final List<Processor> transformerConfig() {
        return this.transformerConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransformerConfig() ? this.transformerConfig() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransformerResponse)) {
            return false;
        }
        GetTransformerResponse other = (GetTransformerResponse)((Object)obj);
        return Objects.equals(this.logGroupIdentifier(), other.logGroupIdentifier()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && this.hasTransformerConfig() == other.hasTransformerConfig() && Objects.equals(this.transformerConfig(), other.transformerConfig());
    }

    public final String toString() {
        return ToString.builder((String)"GetTransformerResponse").add("LogGroupIdentifier", (Object)this.logGroupIdentifier()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("TransformerConfig", this.hasTransformerConfig() ? this.transformerConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.logGroupIdentifier()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "transformerConfig": {
                return Optional.ofNullable(clazz.cast(this.transformerConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("logGroupIdentifier", LOG_GROUP_IDENTIFIER_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("transformerConfig", TRANSFORMER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTransformerResponse, T> g) {
        return obj -> g.apply((GetTransformerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private String logGroupIdentifier;
        private Long creationTime;
        private Long lastModifiedTime;
        private List<Processor> transformerConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransformerResponse model) {
            super(model);
            this.logGroupIdentifier(model.logGroupIdentifier);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.transformerConfig(model.transformerConfig);
        }

        public final String getLogGroupIdentifier() {
            return this.logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final List<Processor.Builder> getTransformerConfig() {
            List<Processor.Builder> result = ProcessorsCopier.copyToBuilder(this.transformerConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransformerConfig(Collection<Processor.BuilderImpl> transformerConfig) {
            this.transformerConfig = ProcessorsCopier.copyFromBuilder(transformerConfig);
        }

        @Override
        public final Builder transformerConfig(Collection<Processor> transformerConfig) {
            this.transformerConfig = ProcessorsCopier.copy(transformerConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformerConfig(Processor ... transformerConfig) {
            this.transformerConfig(Arrays.asList(transformerConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformerConfig(Consumer<Processor.Builder> ... transformerConfig) {
            this.transformerConfig(Stream.of(transformerConfig).map(c -> (Processor)((Processor.Builder)Processor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetTransformerResponse build() {
            return new GetTransformerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTransformerResponse> {
        public Builder logGroupIdentifier(String var1);

        public Builder creationTime(Long var1);

        public Builder lastModifiedTime(Long var1);

        public Builder transformerConfig(Collection<Processor> var1);

        public Builder transformerConfig(Processor ... var1);

        public Builder transformerConfig(Consumer<Processor.Builder> ... var1);
    }
}

