/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.state;

import com.google.common.primitives.SignedBytes;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.mapdb.BTreeMap;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.mapdb.serializer.SerializerByteArray;
import org.opensearch.dataprepper.processor.state.ProcessorState;

public class MapDbProcessorState<V>
implements ProcessorState<byte[], V> {
    private static final SignedByteArraySerializer SIGNED_BYTE_ARRAY_SERIALIZER = new SignedByteArraySerializer();
    private final BTreeMap<byte[], V> map;
    private final File dbFile;

    public MapDbProcessorState(File dbPath, String dbName, int concurrencyScale) {
        this.dbFile = new File(String.join((CharSequence)"/", dbPath.getPath(), dbName));
        this.map = DBMaker.heapDB().executorEnable().closeOnJvmShutdown().concurrencyScale(concurrencyScale).make().treeMap(dbName).counterEnable().keySerializer((GroupSerializer)SIGNED_BYTE_ARRAY_SERIALIZER).valueSerializer(Serializer.JAVA).createOrOpen();
    }

    public void put(byte[] key, V value) {
        this.map.put((Object)key, value);
    }

    public void putAll(Map<byte[], V> data) {
        this.map.putAll(data);
    }

    public V get(byte[] key) {
        return (V)this.map.get((Object)key);
    }

    public Map<byte[], V> getAll() {
        return this.map;
    }

    public <R> List<R> iterate(BiFunction<byte[], V, R> fn) {
        ArrayList returnList = new ArrayList();
        this.map.entryIterator().forEachRemaining(entry -> returnList.add(fn.apply((byte[])entry.getKey(), entry.getValue())));
        return returnList;
    }

    public <R> List<R> iterate(BiFunction<byte[], V, R> fn, int segments, int index) {
        if (this.map.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        KeyRange iterationEndpoints = this.getIterationEndpoints(segments, index);
        ArrayList returnList = new ArrayList();
        this.map.entryIterator((Object)iterationEndpoints.low, true, (Object)iterationEndpoints.high, false).forEachRemaining(entry -> returnList.add(fn.apply((byte[])entry.getKey(), entry.getValue())));
        return returnList;
    }

    public Iterator<Map.Entry<byte[], V>> getIterator(int segments, int index) {
        KeyRange iterationEndpoints = this.getIterationEndpoints(segments, index);
        return this.map.entryIterator((Object)iterationEndpoints.low, true, (Object)iterationEndpoints.high, false);
    }

    private KeyRange getIterationEndpoints(int segments, int index) {
        BigInteger lowEnd = new BigInteger((byte[])this.map.firstKey());
        BigInteger highEnd = new BigInteger((byte[])this.map.lastKey());
        BigInteger step = highEnd.subtract(lowEnd).divide(new BigInteger(String.valueOf(segments)));
        byte[] lowIndex = lowEnd.add(step.multiply(new BigInteger(String.valueOf(index)))).toByteArray();
        byte[] highIndex = index == segments - 1 ? highEnd.add(new BigInteger("1")).toByteArray() : lowEnd.add(step.multiply(new BigInteger(String.valueOf(index + 1)))).toByteArray();
        return new KeyRange(lowIndex, highIndex);
    }

    public long size() {
        return this.map.size();
    }

    public long sizeInBytes() {
        return this.dbFile.length();
    }

    public void clear() {
        this.map.clear();
    }

    public void delete() {
        this.map.close();
    }

    private static class KeyRange {
        public byte[] low;
        public byte[] high;

        public KeyRange(byte[] low, byte[] high) {
            this.low = low;
            this.high = high;
        }
    }

    private static class SignedByteArraySerializer
    extends SerializerByteArray {
        private SignedByteArraySerializer() {
        }

        public int compare(byte[] o1, byte[] o2) {
            return SignedBytes.lexicographicalComparator().compare(o1, o2);
        }
    }
}

