/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.confluence.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.dataprepper.plugins.source.confluence.utils.ConfluenceContentType;

public class PageTypeConfig {
    @JsonProperty(value="include")
    @Size(max=1000, message="Page type filter should not be more than 1000")
    @Size(max=1000, message="Page type filter should not be more than 1000") List<String> include = new ArrayList<String>();
    @JsonProperty(value="exclude")
    @Size(max=1000, message="Page type filter should not be more than 1000")
    @Size(max=1000, message="Page type filter should not be more than 1000") List<String> exclude = new ArrayList<String>();

    @AssertTrue(message="Confluence PageType should be one of [page, blogpost, comment, attachment]")
    @AssertTrue(message="Confluence PageType should be one of [page, blogpost, comment, attachment]") boolean isValidPageType() {
        return this.checkGivenListForValidPageTypes(this.include) && this.checkGivenListForValidPageTypes(this.exclude);
    }

    @AssertTrue(message="There should be no overlap between include and exclude values under PageType filter")
    @AssertTrue(message="There should be no overlap between include and exclude values under PageType filter") boolean noOverlapBetweenIncludeAndExclude() {
        return this.include.stream().noneMatch(this.exclude::contains);
    }

    boolean checkGivenListForValidPageTypes(List<String> list) {
        for (String value : list) {
            if (ConfluenceContentType.fromString(value) != null) continue;
            return false;
        }
        return true;
    }

    public List<String> getInclude() {
        return this.include;
    }

    public List<String> getExclude() {
        return this.exclude;
    }
}

